/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils;

import com.urbancode.commons.fileutils.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFileFilter
implements FileFilter {
    private static int MATCH_ALL = 0;
    private static int MATCH_CURRENT = 1;
    private static int MATCH_EXACT = 2;
    private static int DIRECTORY = 3;
    private File baseDir;
    private boolean excludeOverride = true;
    private Set<String> includes = new LinkedHashSet<String>();
    private Set<String> excludes = new LinkedHashSet<String>();

    public static DirectoryFileFilter getFilter(File baseDir) {
        return DirectoryFileFilter.getFilter(baseDir, true);
    }

    public static DirectoryFileFilter getFilter(File baseDir, boolean excludeOverride) {
        return new DirectoryFileFilter(baseDir, excludeOverride);
    }

    private DirectoryFileFilter(File baseDir, boolean excludeOverride) {
        this.baseDir = baseDir;
        this.excludeOverride = excludeOverride;
    }

    public void addInclude(String include) {
        if (include == null) {
            throw new NullPointerException("FileFilter include can not be null.");
        }
        this.includes.add(include);
    }

    public void addIncludes(String ... includes) {
        if (includes == null) {
            throw new NullPointerException("FileFilter include can not be null.");
        }
        Collections.addAll(this.includes, includes);
    }

    public void addIncludes(Collection<String> includes) {
        if (includes == null) {
            throw new NullPointerException("FileFilter include can not be null.");
        }
        this.includes.addAll(includes);
    }

    public void addExclude(String exclude) {
        if (exclude == null) {
            throw new NullPointerException("FileFilter exclude can not be null.");
        }
        this.excludes.add(exclude);
    }

    public void addExcludes(String ... excludes) {
        if (excludes == null) {
            throw new NullPointerException("FileFilter exclude can not be null.");
        }
        Collections.addAll(this.excludes, excludes);
    }

    public void addExcludes(Collection<String> excludes) {
        if (this.includes == null) {
            throw new NullPointerException("FileFilter exclude can not be null.");
        }
        this.excludes.addAll(excludes);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String[] getIncludes() {
        return this.includes.toArray(new String[this.includes.size()]);
    }

    public String[] getExcludes() {
        return this.excludes.toArray(new String[this.excludes.size()]);
    }

    @Override
    public boolean accept(File file) {
        List<PatternNode> nodes;
        String relativeName = FileUtils.getRelativeFileName(this.baseDir, file);
        boolean test = true;
        if (".".equals(relativeName)) {
            return false;
        }
        if (this.includes.size() > 0) {
            test = false;
            for (String include : this.includes) {
                nodes = this.getPatternNodes(include);
                try {
                    if (!this.match(relativeName, nodes)) continue;
                    test = true;
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        if (test && (this.includes.size() == 0 || this.excludeOverride) && this.excludes.size() > 0) {
            for (String exclude : this.excludes) {
                try {
                    nodes = this.getPatternNodes(exclude);
                    if (!this.match(relativeName, nodes)) continue;
                    return false;
                }
                catch (Exception e) {
                }
            }
        }
        return test;
    }

    private boolean match(String name, List<PatternNode> nodes) throws Exception {
        return this.match(name, nodes, 0, 0);
    }

    private boolean match(String name, List<PatternNode> nodes, int nameIndex, int nodeIndex) throws Exception {
        PatternNode currentNode = nodes.get(nodeIndex);
        if (currentNode.getType() == MATCH_ALL) {
            PatternNode nextNode;
            if ((nextNode = nodes.get(++nodeIndex)) == null || nextNode.getType() != DIRECTORY) {
                throw new Exception("Matching statement not formatted correctly.");
            }
            boolean test = this.match(name, nodes, nameIndex, ++nodeIndex);
            while (!test && name.indexOf(nextNode.getMatch(), nameIndex) >= 0) {
                nameIndex = name.indexOf(nextNode.getMatch(), nameIndex) + nextNode.getMatch().length();
                test = this.match(name, nodes, nameIndex, nodeIndex);
            }
            return test;
        }
        if (currentNode.getType() == MATCH_CURRENT) {
            PatternNode nextNode;
            if (nodeIndex == nodes.size() - 1) {
                return name.indexOf(File.separator, nameIndex) < 0 && name.length() > nameIndex;
            }
            ++nameIndex;
            if ((nextNode = nodes.get(++nodeIndex)).getType() == DIRECTORY) {
                nameIndex = name.indexOf(nextNode.getMatch(), nameIndex);
                if (nameIndex > 0) {
                    return this.match(name, nodes, nameIndex, nodeIndex);
                }
                return false;
            }
            if (nextNode.getType() == MATCH_EXACT) {
                int limitIndex = name.indexOf(File.separator, nameIndex);
                if (limitIndex < 0) {
                    limitIndex = name.length();
                }
                if ((nameIndex = name.indexOf(nextNode.getMatch(), nameIndex)) > 0 && nameIndex < limitIndex) {
                    boolean test = this.match(name, nodes, nameIndex, nodeIndex);
                    while (!test && name.indexOf(nextNode.getMatch(), ++nameIndex) >= 0 && name.indexOf(nextNode.getMatch(), nameIndex) < limitIndex) {
                        nameIndex = name.indexOf(nextNode.getMatch(), nameIndex);
                        test = this.match(name, nodes, nameIndex, nodeIndex);
                    }
                    return test;
                }
                return false;
            }
            throw new Exception("Matching statement not formatted correctly.");
        }
        if (currentNode.getType() == DIRECTORY) {
            if (name.substring(nameIndex++, nameIndex).equals(currentNode.getMatch())) {
                return this.match(name, nodes, nameIndex, ++nodeIndex);
            }
            return false;
        }
        if (name.length() < nameIndex + currentNode.getMatch().length()) {
            return false;
        }
        if (name.substring(nameIndex, nameIndex + currentNode.getMatch().length()).equals(currentNode.getMatch())) {
            if (nodeIndex == nodes.size() - 1) {
                return nameIndex + currentNode.getMatch().length() == name.length();
            }
            return this.match(name, nodes, nameIndex + currentNode.getMatch().length(), ++nodeIndex);
        }
        return false;
    }

    private List<PatternNode> getPatternNodes(String string) {
        ArrayList<PatternNode> nodes = new ArrayList<PatternNode>();
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        StringTokenizer tokenizer = new StringTokenizer(string, File.separator, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("**")) {
                nodes.add(new PatternNode(null, MATCH_ALL));
                continue;
            }
            if (token.indexOf("*") >= 0) {
                StringTokenizer subtokenizer = new StringTokenizer(token, "*", true);
                while (subtokenizer.hasMoreTokens()) {
                    String subtoken = subtokenizer.nextToken();
                    if (subtoken.equals("*")) {
                        nodes.add(new PatternNode(null, MATCH_CURRENT));
                        continue;
                    }
                    nodes.add(new PatternNode(subtoken, MATCH_EXACT));
                }
                continue;
            }
            if (token.equals(File.separator)) {
                nodes.add(new PatternNode(token, DIRECTORY));
                continue;
            }
            nodes.add(new PatternNode(token, MATCH_EXACT));
        }
        return nodes;
    }

    private static class PatternNode {
        private String match;
        private int type;

        PatternNode(String match, int type) {
            this.match = match;
            this.type = type;
        }

        String getMatch() {
            return this.match;
        }

        int getType() {
            return this.type;
        }
    }
}

