/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.xml;

import com.urbancode.air.plugin_command.upgrade.CommandUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginIdUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginVersionMigration;
import com.urbancode.air.plugin_command.upgrade.PropertyGroupUpgrade;
import com.urbancode.air.plugin_command.upgrade.PropertyUpgrade;
import com.urbancode.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerPluginUpgradeXMLContentHandler
extends DefaultHandler {
    public static final String PLUGIN_UPGRADE_ELEMENT = "plugin-upgrade";
    public static final String MIGRATE_ELEMENT = "migrate";
    public static final String MIGRATE_COMMAND_ELEMENT = "migrate-command";
    public static final String MIGRATE_PROPERTIES_ELEMENT = "migrate-properties";
    public static final String MIGRATE_PROPERTY_ELEMENT = "migrate-property";
    public static final String MIGRATE_PROPERTY_GROUP_ELEMENT = "migrate-property-group";
    public static final String REMOVE_COMMAND_ELEMENT = "remove-command";
    public static final String REMOVE_PROPERTY_GROUP_ELEMENT = "remove-property-group";
    public static final String REMOVE_PROPERTIES_ELEMENT = "remove-properties";
    public static final String REMOVE_PROPERTY_ELEMENT = "remove-property";
    public static final String MIGRATE_PLUGIN_ID_ELEMENT = "migrate-id";
    public static final String NEW_ATTRIBUTE = "new";
    public static final String TO_VERSION_ATTRIBUTE = "to-version";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String OLD_ATTRIBUTE = "old";
    public static final String DEFAULT_ATTRIBUTE = "default";
    protected Stack<String> tagNameStack = new Stack();
    protected PluginUpgrade pluginUpgrade = null;
    protected PluginVersionMigration curPluginVersionMigration = null;
    protected CommandUpgrade curCommandUpgrade = null;
    protected PropertyGroupUpgrade curPropertyGroupUpgrade = null;
    protected PropertyUpgrade curPropertyUpgrade = null;
    protected List<String> removedPropertyNames = new ArrayList<String>();
    protected List<PropertyUpgrade> propertyUpgrades = new ArrayList<PropertyUpgrade>();
    protected List<PluginVersionMigration> migrations = new ArrayList<PluginVersionMigration>();
    protected Long version = null;
    protected String name = null;
    protected String type = null;
    protected String old = null;
    protected String defaultValue = null;
    protected boolean upgradingCommand = false;
    protected boolean upgradingGroup = false;
    protected String oldPluginId = null;
    protected String newPluginId = null;
    protected PluginIdUpgrade curPluginIdUpgrade = null;
    protected StringBuilder tagText = new StringBuilder();

    public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.equals(PLUGIN_UPGRADE_ELEMENT)) {
            this.handlePluginStart(attrs);
        } else if (localName.equals(MIGRATE_ELEMENT)) {
            this.handleMigrateVersionStart(attrs);
        } else if (localName.equals(MIGRATE_COMMAND_ELEMENT)) {
            this.handleMigrateCommandStart(attrs);
        } else if (qName.equals(MIGRATE_PROPERTY_GROUP_ELEMENT)) {
            this.handleMigratePropertyGroupStart(attrs);
        } else if (localName.equals(MIGRATE_PROPERTIES_ELEMENT)) {
            this.handleMigratePropertiesStart(attrs);
        } else if (localName.equals(MIGRATE_PROPERTY_ELEMENT)) {
            this.handleMigratePropertyStart(attrs);
        } else if (localName.equals(REMOVE_COMMAND_ELEMENT)) {
            this.handleRemoveCommandStart(attrs);
        } else if (localName.equals(REMOVE_PROPERTY_GROUP_ELEMENT)) {
            this.handleRemovePropertyGroupStart(attrs);
        } else if (localName.equals(REMOVE_PROPERTIES_ELEMENT)) {
            this.handleRemovePropertiesStart(attrs);
        } else if (localName.equals(REMOVE_PROPERTY_ELEMENT)) {
            this.handleRemovePropertyStart(attrs);
        } else if (localName.equals(MIGRATE_PLUGIN_ID_ELEMENT)) {
            this.handleMigratePluginIdStart(attrs);
        } else {
            throw new SAXException("Unknown Element: " + localName);
        }
        this.tagNameStack.push(localName);
        this.tagText = new StringBuilder();
    }

    public void endElement(String ns, String localName, String qName) throws SAXException {
        if (localName.equals(PLUGIN_UPGRADE_ELEMENT)) {
            this.handlePluginEnd();
        } else if (localName.equals(MIGRATE_ELEMENT)) {
            this.handleMigrateVersionEnd();
        } else if (localName.equals(MIGRATE_COMMAND_ELEMENT)) {
            this.handleMigrateCommandEnd();
        } else if (qName.equals(MIGRATE_PROPERTY_GROUP_ELEMENT)) {
            this.handleMigratePropertyGroupEnd();
        } else if (localName.equals(REMOVE_COMMAND_ELEMENT)) {
            this.handleRemoveCommandEnd();
        } else if (localName.equals(REMOVE_PROPERTY_GROUP_ELEMENT)) {
            this.handleRemovePropertyGroupEnd();
        } else if (localName.equals(MIGRATE_PROPERTIES_ELEMENT)) {
            this.handleMigratePropertiesEnd();
        } else if (localName.equals(MIGRATE_PROPERTY_ELEMENT)) {
            this.handleMigratePropertyEnd();
        } else if (localName.equals(REMOVE_PROPERTIES_ELEMENT)) {
            this.handleRemovePropertiesEnd();
        } else if (localName.equals(REMOVE_PROPERTY_ELEMENT)) {
            this.handleRemovePropertyEnd();
        } else if (localName.equals(MIGRATE_PLUGIN_ID_ELEMENT)) {
            this.handleMigratePluginIdEnd();
        } else {
            throw new SAXException("Unknown Element: " + localName);
        }
        this.tagNameStack.pop();
        this.tagText = new StringBuilder();
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.tagText.append(chars, start, length);
    }

    protected void handlePluginStart(Attributes attrs) throws SAXException {
        if (!this.tagNameStack.isEmpty()) {
            throw new SAXException("element plugin has to be the root element!");
        }
        if (attrs.getLength() != 0) {
            throw new SAXException("plugin should not have any attributes on it.");
        }
        this.pluginUpgrade = new PluginUpgrade();
    }

    protected void handlePluginEnd() throws SAXException {
        for (PluginVersionMigration migration : this.migrations) {
            this.pluginUpgrade.addPluginVersionMigration(migration);
        }
        this.migrations.clear();
    }

    protected void handleMigrateVersionStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PLUGIN_UPGRADE_ELEMENT, MIGRATE_ELEMENT);
        String versionStr = attrs.getValue(TO_VERSION_ATTRIBUTE);
        if (StringUtil.isEmpty((String)versionStr)) {
            throw new SAXException("\"to-version\" attribute must be given for a \"migrate\" element");
        }
        try {
            this.version = Long.valueOf(attrs.getValue(TO_VERSION_ATTRIBUTE));
            if (this.version < 0L || this.version == null) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new SAXException("\"to-version\" attribute value must be a positive integer.");
        }
        this.curPluginVersionMigration = new PluginVersionMigration(this.version.longValue());
    }

    protected void handleMigrateVersionEnd() throws SAXException {
        this.migrations.add(this.curPluginVersionMigration);
        this.version = null;
        this.curPluginVersionMigration = null;
    }

    protected void handleMigrateCommandStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_ELEMENT, MIGRATE_COMMAND_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        this.old = attrs.getValue(OLD_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name)) {
            throw new SAXException("The \"name\" attribute is required");
        }
        this.curCommandUpgrade = new CommandUpgrade(this.name, this.old);
        this.upgradingCommand = true;
    }

    protected void handleMigrateCommandEnd() throws SAXException {
        this.curPluginVersionMigration.addCommandUpgrade(this.curCommandUpgrade);
        this.curCommandUpgrade = null;
        this.name = null;
        this.old = null;
        this.upgradingCommand = false;
    }

    protected void handleRemoveCommandStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_ELEMENT, REMOVE_COMMAND_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name)) {
            throw new SAXException("The \"name\" attribute is required");
        }
        this.curPluginVersionMigration.addRemovedCommand(this.name);
    }

    protected void handleRemoveCommandEnd() throws SAXException {
        this.name = null;
    }

    protected void handleMigratePropertyGroupStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_ELEMENT, MIGRATE_PROPERTY_GROUP_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        this.old = attrs.getValue(OLD_ATTRIBUTE);
        this.type = attrs.getValue(TYPE_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name)) {
            throw new SAXException("The \"name\" attribute is required");
        }
        this.curPropertyGroupUpgrade = new PropertyGroupUpgrade(this.name, this.old, this.type);
        this.upgradingGroup = true;
    }

    protected void handleMigratePropertyGroupEnd() throws SAXException {
        this.curPluginVersionMigration.addPropertyGroupUpgrade(this.curPropertyGroupUpgrade);
        this.curPropertyGroupUpgrade = null;
        this.name = null;
        this.old = null;
        this.upgradingGroup = false;
    }

    protected void handleRemovePropertyGroupStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_ELEMENT, MIGRATE_PROPERTY_GROUP_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        this.type = attrs.getValue(TYPE_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name) || StringUtil.isEmpty((String)this.type)) {
            throw new SAXException("The \"name\" and \"type\" attributes are required to remove a property group.");
        }
        this.curPluginVersionMigration.addRemovedPropertyGroup(this.name, this.type);
    }

    protected void handleRemovePropertyGroupEnd() throws SAXException {
        this.name = null;
    }

    protected void handleMigratePropertiesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{MIGRATE_COMMAND_ELEMENT, MIGRATE_PROPERTY_GROUP_ELEMENT}, MIGRATE_PROPERTIES_ELEMENT);
    }

    protected void handleMigratePropertiesEnd() throws SAXException {
        for (PropertyUpgrade propUpgrade : this.propertyUpgrades) {
            if (this.upgradingCommand) {
                this.curCommandUpgrade.addPropertyUpgrade(propUpgrade);
                continue;
            }
            if (this.upgradingGroup) {
                this.curPropertyGroupUpgrade.addPropertyUpgrade(propUpgrade);
                continue;
            }
            throw new SAXException("A property upgrade appears to have occurred within an unrecognized parent element.");
        }
        this.propertyUpgrades.clear();
    }

    protected void handleRemovePropertiesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{MIGRATE_COMMAND_ELEMENT, MIGRATE_PROPERTY_GROUP_ELEMENT}, REMOVE_PROPERTIES_ELEMENT);
    }

    protected void handleRemovePropertiesEnd() throws SAXException {
        for (String propToRemove : this.removedPropertyNames) {
            if (this.upgradingCommand) {
                this.curCommandUpgrade.addRemovedProperty(propToRemove);
                continue;
            }
            if (this.upgradingGroup) {
                this.curPropertyGroupUpgrade.addRemovedProperty(propToRemove);
                continue;
            }
            throw new SAXException("A property upgrade appears to have occurred within an unrecognized parent element.");
        }
        this.removedPropertyNames.clear();
    }

    protected void handleMigratePropertyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_PROPERTIES_ELEMENT, MIGRATE_PROPERTY_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        this.old = attrs.getValue(OLD_ATTRIBUTE);
        this.defaultValue = attrs.getValue(DEFAULT_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name)) {
            throw new SAXException("\"name\" is a required attribute.");
        }
        this.curPropertyUpgrade = new PropertyUpgrade(this.name, this.old, this.defaultValue);
        this.propertyUpgrades.add(this.curPropertyUpgrade);
    }

    protected void handleMigratePropertyEnd() throws SAXException {
        this.name = null;
        this.old = null;
        this.defaultValue = null;
        this.curPropertyUpgrade = null;
    }

    protected void handleRemovePropertyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(REMOVE_PROPERTIES_ELEMENT, REMOVE_PROPERTY_ELEMENT);
        this.name = attrs.getValue(NAME_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.name)) {
            throw new SAXException("\"name\" is a required attribute.");
        }
        this.removedPropertyNames.add(this.name);
    }

    protected void handleMigratePluginIdStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(MIGRATE_ELEMENT, MIGRATE_PLUGIN_ID_ELEMENT);
        this.oldPluginId = attrs.getValue(OLD_ATTRIBUTE);
        this.newPluginId = attrs.getValue(NEW_ATTRIBUTE);
        if (StringUtil.isEmpty((String)this.oldPluginId)) {
            throw new SAXException("\"old\" is a required attribute.");
        }
        if (StringUtil.isEmpty((String)this.newPluginId)) {
            throw new SAXException("\"new\" is a required attribute.");
        }
        this.curPluginIdUpgrade = new PluginIdUpgrade(this.oldPluginId, this.newPluginId);
    }

    protected void handleMigratePluginIdEnd() throws SAXException {
        this.curPluginVersionMigration.setIdUpgrade(this.curPluginIdUpgrade);
        this.newPluginId = null;
        this.oldPluginId = null;
        this.curPluginIdUpgrade = null;
    }

    protected void handleRemovePropertyEnd() throws SAXException {
        this.name = null;
    }

    protected void checkParentElementType(String expectedParent, String elementName) throws SAXException {
        this.checkParentElementType(new String[]{expectedParent}, elementName);
    }

    protected void checkParentElementType(String[] expectedParents, String elementName) throws SAXException {
        boolean hasGoodParent = false;
        String actualParent = this.tagNameStack.peek();
        for (String expectedParent : expectedParents) {
            if (!expectedParent.equals(actualParent)) continue;
            hasGoodParent = true;
            break;
        }
        if (!hasGoodParent) {
            String errString = elementName + " element can only appear in one of the " + "following elements :";
            boolean first = true;
            for (String expectedParent : expectedParents) {
                if (first) {
                    errString = errString + expectedParent;
                    first = false;
                    continue;
                }
                errString = errString + ", " + expectedParent;
            }
            errString = errString + "\n not :";
            boolean firstTag = true;
            while (!this.tagNameStack.isEmpty()) {
                String tagNamePar = this.tagNameStack.pop();
                if (firstTag) {
                    errString = errString + tagNamePar;
                    firstTag = false;
                    continue;
                }
                errString = errString + "->" + tagNamePar;
            }
            throw new SAXException(errString);
        }
    }

    public PluginUpgrade getPluginUpgrade() {
        return this.pluginUpgrade;
    }

    protected String getTagStackPath() {
        return this.tagNameStack.toString();
    }
}

