/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.iterator.files.EachDirectoryIterator;
import com.urbancode.commons.util.iterator.files.EachDirectoryPIterator;
import com.urbancode.commons.util.iterator.files.EachDirectoryRecursiveIterator;
import com.urbancode.commons.util.iterator.files.EachDirectoryRecursivePIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryPIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryPPIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryRecursiveIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryRecursivePIterator;
import com.urbancode.commons.util.iterator.files.EachFileAndDirectoryRecursivePPIterator;
import com.urbancode.commons.util.iterator.files.EachFileFilterIterator;
import com.urbancode.commons.util.iterator.files.EachFileIterator;
import com.urbancode.commons.util.iterator.files.EachFilePIterator;
import com.urbancode.commons.util.iterator.files.EachFileRecursiveIterator;
import com.urbancode.commons.util.iterator.files.EachFileRecursivePIterator;
import com.urbancode.commons.util.iterator.files.EachFileRecursivePPIterator;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public final class Files {
    private static final Pattern excludeDotFilesPattern = Pattern.compile("(?!\\.).*");
    private static final Pattern includeAllFilesPattern = Pattern.compile(".*");

    public static Iterable<File> eachDirectory(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachDirectoryIterator(d);
            }
        };
    }

    public static Iterable<File> eachDirectory(File directory, Pattern directoryPattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(directoryPattern, "directoryPattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachDirectoryPIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachDirectoryRecursive(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachDirectoryRecursiveIterator(d);
            }
        };
    }

    public static Iterable<File> eachDirectoryRecursive(File directory, Pattern directoryPattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(directoryPattern, "directoryPattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachDirectoryRecursivePIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachFile(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileIterator(d);
            }
        };
    }

    public static Iterable<File> eachFile(File directory, Pattern filePattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFilePIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectory(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryIterator(d);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectory(File directory, Pattern filePattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryPIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectory(File directory, Pattern filePattern, Pattern directoryPattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        final Pattern dp = Check.nonNull(directoryPattern, "directoryPattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryPPIterator(d, fp, dp);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectoryRecursive(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryRecursiveIterator(d);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectoryRecursive(File directory, Pattern filePattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryRecursivePIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachFileAndDirectoryRecursive(File directory, Pattern filePattern, Pattern directoryPattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        final Pattern dp = Check.nonNull(directoryPattern, "directoryPattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileAndDirectoryRecursivePPIterator(d, fp, dp);
            }
        };
    }

    public static Iterable<File> eachFileRecursive(File directory) {
        final File d = Check.nonNull(directory, "directory");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileRecursiveIterator(d);
            }
        };
    }

    public static Iterable<File> eachFileRecursive(File directory, Pattern filePattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileRecursivePIterator(d, fp);
            }
        };
    }

    public static Iterable<File> eachFileRecursive(File directory, Pattern filePattern, Pattern directoryPattern) {
        final File d = Check.nonNull(directory, "directory");
        final Pattern fp = Check.nonNull(filePattern, "filePattern");
        final Pattern dp = Check.nonNull(directoryPattern, "directoryPattern");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileRecursivePPIterator(d, fp, dp);
            }
        };
    }

    public static Iterable<File> eachFile(File base, FileFilter traverser, FileFilter acceptor) {
        final File directory = Check.nonNull(base, "directory");
        final FileFilter traversalFilter = Check.nonNull(traverser, "traverser");
        final FileFilter acceptFilter = Check.nonNull(acceptor, "acceptor");
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new EachFileFilterIterator(directory, traversalFilter, acceptFilter);
            }
        };
    }

    public static Pattern excludeDotFiles() {
        return excludeDotFilesPattern;
    }

    public static Pattern includeAllFiles() {
        return includeAllFilesPattern;
    }

    private Files() {
        throw new UnsupportedOperationException();
    }
}

