/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils;

import com.urbancode.commons.util.FileFilterToRegex;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNameFilter {
    List<FilterRule> filterList = new ArrayList<FilterRule>();

    public FileNameFilter(String[] filterArray) {
        if (filterArray != null) {
            for (String element : filterArray) {
                String filter = element.trim();
                Pattern pattern = FileFilterToRegex.convert(filter.substring(1));
                if (filter.startsWith("+")) {
                    this.filterList.add(new FilterRule(pattern, true));
                    continue;
                }
                if (!filter.startsWith("-")) continue;
                this.filterList.add(new FilterRule(pattern, false));
            }
        }
    }

    public FileNameFilter(List<String> filters) {
        if (filters != null) {
            for (String filter : filters) {
                filter = filter.trim();
                Pattern pattern = FileFilterToRegex.convert(filter.substring(1));
                if (filter.startsWith("+")) {
                    this.filterList.add(new FilterRule(pattern, true));
                    continue;
                }
                if (!filter.startsWith("-")) continue;
                this.filterList.add(new FilterRule(pattern, false));
            }
        }
    }

    public boolean isIncluded(String input) {
        boolean result = false;
        if (input != null) {
            result = true;
            for (FilterRule rule : this.filterList) {
                if (!rule.filter.matcher(input).matches()) continue;
                result = rule.includeFilter;
            }
        }
        return result;
    }

    public boolean isExcluded(String input) {
        boolean result = false;
        if (input != null) {
            for (FilterRule rule : this.filterList) {
                if (!rule.filter.matcher(input).matches()) continue;
                result = rule.includeFilter;
            }
        }
        return result;
    }

    private static class FilterRule {
        Pattern filter;
        boolean includeFilter = true;

        FilterRule(Pattern filter, boolean includeFilter) {
            this.filter = filter;
            this.includeFilter = includeFilter;
        }
    }
}

