/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.sync;

import com.urbancode.commons.fileutils.sync.SynchronizedDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Deprecated
public class DirectoryAccessSynchronizer {
    private static int MAX_HASH_SIZE = 400;
    private static int HASH_THRESHOLD = 100;
    static String LOCK_FILE_NAME = ".dir.lock";
    static String ACCESSED_FILE_NAME = ".dir.accessed";
    private final Map dirMap = Collections.synchronizedMap(new HashMap());
    private final int maxHashSize;
    private final int hashThreshold;

    public DirectoryAccessSynchronizer() {
        this(MAX_HASH_SIZE);
    }

    public DirectoryAccessSynchronizer(int maxHashSize) {
        this(maxHashSize, HASH_THRESHOLD);
    }

    public DirectoryAccessSynchronizer(int maxHashSize, int hashThreshold) {
        this.maxHashSize = maxHashSize;
        this.hashThreshold = hashThreshold;
    }

    public void beginWriteAction(File dir) throws InterruptedException, IOException {
        SynchronizedDirectory syncDir = this.getSynchronizedDir(dir);
        syncDir.beginWriteAction();
    }

    public void endWriteAction(File dir) {
        try {
            SynchronizedDirectory syncDir = this.getSynchronizedDir(dir);
            syncDir.endWriteAction();
            this.cleanDirMap();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getLastAccessTime(File dir) throws IOException {
        SynchronizedDirectory syncDir = this.getSynchronizedDir(dir);
        return syncDir.getLastAccessTime();
    }

    public void beginReadAction(File dir) throws InterruptedException, IOException {
        SynchronizedDirectory syncDir = this.getSynchronizedDir(dir);
        syncDir.beginReadAction();
    }

    public void endReadAction(File dir) {
        try {
            SynchronizedDirectory syncDir = this.getSynchronizedDir(dir);
            syncDir.endReadAction();
            this.cleanDirMap();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getHashSize() {
        return this.dirMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActiveSynchronizedDirSize() {
        int result = 0;
        Map map = this.dirMap;
        synchronized (map) {
            for (SynchronizedDirectory syncDir : this.dirMap.values()) {
                if (!syncDir.isInUse()) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SynchronizedDirectory getSynchronizedDir(File dir) throws IOException {
        SynchronizedDirectory result = null;
        if (dir != null) {
            dir = dir.getCanonicalFile();
            Map map = this.dirMap;
            synchronized (map) {
                result = (SynchronizedDirectory)this.dirMap.get(dir);
                if (result == null) {
                    result = this.createSynchronizedDir(dir);
                    this.dirMap.put(dir, result);
                }
                result.addCurrentThreadToUseSet();
            }
        }
        return result;
    }

    private SynchronizedDirectory createSynchronizedDir(File dir) throws IOException {
        File lockFile = new File(dir, LOCK_FILE_NAME);
        File accessedFile = new File(dir, ACCESSED_FILE_NAME);
        SynchronizedDirectory result = new SynchronizedDirectory(dir, lockFile, accessedFile);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDirMap() {
        Map map = this.dirMap;
        synchronized (map) {
            if (this.dirMap.size() > this.maxHashSize) {
                Iterator itr = this.dirMap.values().iterator();
                while (itr.hasNext() && this.dirMap.values().size() > this.maxHashSize - this.hashThreshold) {
                    SynchronizedDirectory syncDir = (SynchronizedDirectory)itr.next();
                    if (syncDir.isInUse()) continue;
                    itr.remove();
                }
            }
        }
    }
}

