/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.weighted;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.weighted.WeightFunction;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class WeightedObject<W extends Comparable<W>, T>
implements Comparable<WeightedObject<W, T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private W weight;
    private T object;

    public static <W extends Comparable<W>, T> WeightedObject<W, T> weight(T object, WeightFunction<W, T> function) {
        W weight = function.weight(object);
        return WeightedObject.create(weight, object);
    }

    public static <W extends Comparable<W>, T> WeightedObject<W, T> create(W weight, T object) {
        return new WeightedObject<W, T>(weight, object);
    }

    public WeightedObject(W weight, T object) {
        this.object = object;
        this.weight = weight;
    }

    public String toString() {
        return "(" + this.getWeight() + ", " + this.getObject() + ")";
    }

    @Override
    public int compareTo(WeightedObject<W, T> o) {
        return this.getWeight().compareTo(o.getWeight());
    }

    public W getWeight() {
        return this.weight;
    }

    protected void setWeight(W weight) {
        this.weight = weight;
    }

    public T getObject() {
        return this.object;
    }

    protected void setObject(T object) {
        this.object = object;
    }
}

