/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class NumberAwareStringComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(String string1, String string2) {
        Check.nonNull(string1, "string1");
        Check.nonNull(string2, "string2");
        int pos1 = 0;
        int pos2 = 0;
        int result = 0;
        while (pos1 < string1.length() && pos2 < string2.length() && result == 0) {
            char char1 = string1.charAt(pos1);
            char char2 = string2.charAt(pos2);
            if (Character.isDigit(char1) && Character.isDigit(char2)) {
                String sub1 = this.getNumericRun(string1, pos1);
                String sub2 = this.getNumericRun(string2, pos2);
                result = this.compareNumericStrings(sub1, sub2);
                pos1 += sub1.length();
                pos2 += sub2.length();
                continue;
            }
            if (Character.isDigit(char1)) {
                result = -1;
                continue;
            }
            if (Character.isDigit(char2)) {
                result = 1;
                continue;
            }
            result = char1 - char2;
            ++pos1;
            ++pos2;
        }
        return result;
    }

    protected String getNumericRun(String value, int pos) {
        int end;
        for (end = pos; end < value.length() && Character.isDigit(value.charAt(end)); ++end) {
        }
        return value.substring(pos, end);
    }

    protected int compareNumericStrings(String string1, String string2) {
        if (string1.equals(string2)) {
            return 0;
        }
        String skip1 = string1;
        while (skip1.length() > 1 && skip1.charAt(0) == '0') {
            skip1 = skip1.substring(1);
        }
        String skip2 = string2;
        while (skip2.length() > 1 && skip2.charAt(0) == '0') {
            skip2 = skip2.substring(1);
        }
        if (skip1.length() != skip2.length()) {
            return skip1.length() - skip2.length();
        }
        int result = skip1.compareTo(skip2);
        if (result == 0) {
            result = string1.length() - string2.length();
        }
        return result;
    }
}

