/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.ext;

import com.urbancode.air.plugin.server.ext.PropertyGroupPropertyUI;
import com.urbancode.air.plugin_command.properties.SelectValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyGroupProperty {
    private String name;
    private boolean required;
    private List<SelectValue> allowedValues;
    private PropertyGroupPropertyUI propertyUI;

    public PropertyGroupProperty(String name, boolean required, List<SelectValue> allowedValues) {
        this.name = name;
        this.required = required;
        this.allowedValues = allowedValues;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<SelectValue> getAllowedValues() {
        return this.allowedValues;
    }

    public PropertyGroupPropertyUI getPropertyUI() {
        return this.propertyUI;
    }

    public void setPropertyUI(PropertyGroupPropertyUI propertyUI) {
        this.propertyUI = propertyUI;
    }

    public String toString() {
        return "PluginProperty(" + this.name + ", " + this.required + ")";
    }

    public void addAllowedValue(SelectValue value) {
        if (this.allowedValues == null) {
            this.allowedValues = new ArrayList<SelectValue>();
        }
        if (!this.allowedValues.contains(value)) {
            this.allowedValues.add(value);
        }
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public boolean apiEquals(PropertyGroupProperty that) {
        boolean result;
        boolean bl = result = this.isRequired() == that.isRequired();
        if (result) {
            HashSet<String> thisValues = new HashSet<String>();
            for (SelectValue val : this.allowedValues) {
                thisValues.add(val.getValue());
            }
            HashSet<String> thatValues = new HashSet<String>();
            for (SelectValue val : that.allowedValues) {
                thatValues.add(val.getValue());
            }
            result = ((Object)thisValues).equals(thatValues);
        }
        if (result) {
            result = this.propertyUI.apiEquals(that.propertyUI);
        }
        return result;
    }
}

