/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.util.PercentCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDRestClient {
    private static final Logger log = Logger.getLogger(UDRestClient.class);
    public static final int WAIT_RANGE_MIN_DEFAULT = 200;
    public static final int WAIT_RANGE_MAX_DEFAULT = 1000;
    public static final int RETRY_LIMIT_DEFAULT = 3;
    protected final URI url;
    protected final String clientUser;
    protected final String clientPassword;
    protected final DefaultHttpClient client;

    public static DefaultHttpClient createHttpClient(String user, String password) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(user);
        builder.setPassword(password);
        String verifyServerIdentityString = System.getenv().get("UC_TLS_VERIFY_CERTS");
        Boolean trustAllCerts = Boolean.valueOf(verifyServerIdentityString);
        builder.setTrustAllCerts(trustAllCerts == false);
        if (!StringUtils.isEmpty(System.getenv("PROXY_HOST")) && StringUtils.isNumeric(System.getenv("PROXY_PORT"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyHost(System.getenv("PROXY_HOST"));
            builder.setProxyPort(Integer.valueOf(System.getenv("PROXY_PORT")));
        }
        if (!StringUtils.isEmpty(System.getenv("PROXY_USERNAME")) && !StringUtils.isEmpty(System.getenv("PROXY_PASSWORD"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyUsername(System.getenv("PROXY_USERNAME"));
            builder.setProxyPassword(System.getenv("PROXY_PASSWORD"));
        }
        return builder.buildClient();
    }

    public UDRestClient(URI url, String clientUser, String clientPassword) {
        this.url = url;
        this.clientUser = clientUser;
        this.clientPassword = clientPassword;
        this.client = UDRestClient.createHttpClient(clientUser, clientPassword);
    }

    public UDRestClient(URI url, DefaultHttpClient client) {
        Check.nonNull(url);
        Check.nonNull(client);
        this.url = url;
        this.client = client;
        this.clientUser = null;
        this.clientPassword = null;
    }

    protected JSONObject createNewPropertyJSON(String name, String value, boolean isSecure) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("name", name).put("value", value).put("secure", isSecure);
        return result;
    }

    protected JSONObject convertPropArrayToKeyValuePairs(JSONArray propArray) throws JSONException {
        JSONObject result = new JSONObject();
        for (int i = 0; i < propArray.length(); ++i) {
            JSONObject prop = propArray.getJSONObject(i);
            JSONObject propDefJSON = null;
            try {
                propDefJSON = (JSONObject)prop.get("propValue");
            }
            catch (JSONException e) {
                propDefJSON = (JSONObject)prop.get("propDef");
            }
            String propKey = (String)propDefJSON.get("name");
            String propValue = (String)propDefJSON.get("value");
            result.put(propKey, propValue);
        }
        return result;
    }

    protected StringEntity getStringEntity(Object object) {
        return new StringEntity(object.toString(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBody(HttpResponse response) throws IOException {
        String result = null;
        StringBuilder builder = new StringBuilder();
        if (response.getStatusLine().getStatusCode() != 204) {
            InputStream body = response.getEntity().getContent();
            if (body != null) {
                InputStreamReader reader = IO.reader(body, IO.utf8());
                try {
                    IO.copy((Reader)reader, builder);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            result = builder.toString();
        }
        return result;
    }

    protected void discardBody(HttpResponse response) throws IOException {
        EntityUtils.consumeQuietly(response.getEntity());
    }

    protected HttpResponse invokeMethod(HttpRequestBase request) throws IOException, ClientProtocolException {
        CloseableHttpResponse response = this.client.execute(request);
        int status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
        return response;
    }

    protected HttpResponse retryInvokeMethod(HttpRequestBase request, String logMethodName) throws IOException {
        return this.retryInvokeMethod(request, logMethodName, 200, 1000, 3);
    }

    protected HttpResponse retryInvokeMethod(HttpRequestBase request, String logMethodName, int waitRangeMin, int waitRangeMax, int retryLimit) throws IOException {
        if (waitRangeMin < 0) {
            log.debug("Retry minimum wait [" + waitRangeMin + "] is invalid, using " + 200);
            waitRangeMin = 200;
        }
        if (waitRangeMax < 0) {
            log.debug("Retry maximum wait [" + waitRangeMax + "] is invalid, using " + 1000);
            waitRangeMax = 1000;
        }
        if (waitRangeMax < waitRangeMin) {
            int tmpMax = waitRangeMax;
            waitRangeMax = waitRangeMin;
            waitRangeMin = tmpMax;
        }
        if (retryLimit < 0) {
            log.debug("Retry limit [" + retryLimit + "] is invalid, using " + 3);
            retryLimit = 3;
        }
        int waitRandomLimit = waitRangeMax - waitRangeMin + 1;
        int tryCount = 0;
        Random random = new Random();
        CloseableHttpResponse response = null;
        int status = 0;
        while ((status = (response = this.client.execute(request)).getStatusLine().getStatusCode()) == 409) {
            if (++tryCount > retryLimit) {
                if (retryLimit > 0 && logMethodName != null) {
                    System.out.println("Reached retry limit");
                }
                throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
            }
            if (logMethodName != null) {
                System.out.println("Retrying " + logMethodName);
            }
            long wait = random.nextInt(waitRandomLimit) + waitRangeMin;
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e1) {
                System.out.println(e1);
            }
        }
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
        return response;
    }

    protected void releaseConnection(HttpRequestBase request) {
        request.releaseConnection();
    }

    protected String encodePath(String path) {
        String result;
        try {
            result = this.sanitizePathSegment(path);
        }
        catch (Exception e) {
            log.debug("the user input " + path + " could not be sanitized. defaulting to user input", e);
            result = path;
        }
        return result;
    }

    protected String sanitizePathSegment(String path) throws URISyntaxException, EncoderException {
        PercentCodec encoder = new PercentCodec();
        return encoder.encode(path);
    }

    public Map<String, String> getJSONAsProperties(JSONObject object) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = object.get(key);
                if (value instanceof JSONObject || value instanceof JSONArray) continue;
                result.put(key, String.valueOf(value));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to convert from JSON to map", e);
        }
        return result;
    }
}

