/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XercesUtils {
    private static final Logger log = Logger.getLogger(XercesUtils.class);
    public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    public static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String LOAD_DTD_GRAMMAR_FEATURE = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    public static final String XINCLUDE_FEATURE = "http://apache.org/xml/features/xinclude";
    public static final String VALIDATING_FEATURE = "http://xml.org/sax/features/validation";
    public static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String SECURITY_MANAGER_PARSER_PROPERTY = "http://apache.org/xml/properties/security-manager";

    public static void silentSetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            log.debug("Ignoring unsupported feature " + feature);
        }
    }

    public static EntityResolver whitelistSafeResolver(String ... systemIdWhitelist) {
        return new WhitelistSafeEntityResolver(Arrays.asList(systemIdWhitelist));
    }

    private XercesUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhitelistSafeEntityResolver
    implements EntityResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        Set<String> allowedSystemIds;
        boolean strict = true;

        WhitelistSafeEntityResolver(Collection<String> allowedSystemIds) {
            this.allowedSystemIds = new HashSet<String>(allowedSystemIds);
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId == null || this.startsWithIgnoreCase(systemId, "urn:") || this.allowedSystemIds.contains(systemId)) {
                return null;
            }
            if (this.strict) {
                throw new IllegalArgumentException("Attempt to load restricted system entity [" + publicId + ", " + systemId + "]");
            }
            return this.dummySource(systemId);
        }

        boolean startsWithIgnoreCase(String thisString, String prefix) {
            return thisString.length() >= prefix.length() && thisString.regionMatches(true, 0, prefix, 0, prefix.length());
        }

        boolean endsWithIgnoreCase(String thisString, String suffix) {
            return thisString.length() >= suffix.length() && thisString.regionMatches(true, thisString.length() - suffix.length(), suffix, 0, suffix.length());
        }

        InputSource dummySource(String systemId) throws UnsupportedEncodingException {
            String stubContent = "<?xml version='1.0' encoding='UTF-8'?>";
            if (this.endsWithIgnoreCase(systemId, ".xsd")) {
                stubContent = stubContent + "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'></xs:schema>";
            }
            return new InputSource(new ByteArrayInputStream(stubContent.getBytes("UTF-8")));
        }
    }
}

