/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import com.urbancode.commons.httpcomponentsutil.CloseableHttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.proxy.ProxyResponse;
import com.urbancode.commons.web.proxy.ProxyResponseFactory;
import com.urbancode.commons.web.proxy.ProxyResponseHeader;
import com.urbancode.commons.web.proxy.ReverseProxyCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class ReverseProxyServlet
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ReverseProxyServlet.class);
    private static final String TARGET_INIT_PARAM = "target-uri";
    private static final String DEFAULT_TARGET = "http://localhost:8080";
    public static final int PROXY_REQUEST_TIMEOUT_MILLIS = Integer.getInteger("com.urbancode.commons.web.proxy.ReverseProxyServlet.PROXY_REQUEST_TIMEOUT_MILLIS", 600000);
    public static final String CACHE_PATTERNS_PARAM = "cache-patterns";
    private static final Set<String> SINGLE_HOP_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> PROXY_HEADERS;
    private static final RedirectStrategy NO_FOLLOW_REDIRECT;
    String targetOrigin;
    URI targetUri;
    List<Pattern> cachePatterns = Collections.emptyList();
    ReverseProxyCache cache = new ReverseProxyCache();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.targetOrigin = StringUtils.defaultIfEmpty(config.getInitParameter(TARGET_INIT_PARAM), DEFAULT_TARGET);
        if (!this.targetOrigin.endsWith("/")) {
            this.targetOrigin = this.targetOrigin + "/";
        }
        if (!this.targetOrigin.startsWith("http")) {
            this.targetOrigin = "http://" + this.targetOrigin;
        }
        try {
            this.targetUri = new URI(this.targetOrigin);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        String cachePatternsString = config.getInitParameter(CACHE_PATTERNS_PARAM);
        ArrayList<Pattern> cachePatterns = new ArrayList<Pattern>();
        if (StringUtils.isNotEmpty(cachePatternsString)) {
            for (String line : cachePatternsString.split("\r\n|\r|\n")) {
                if (!StringUtils.isNotEmpty(line = line.trim())) continue;
                cachePatterns.add(Pattern.compile(line));
            }
        }
        this.cachePatterns = Collections.unmodifiableList(cachePatterns);
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
        boolean useCache;
        HttpServletRequest clientRequest = (HttpServletRequest)arg0;
        HttpServletResponse clientResponse = (HttpServletResponse)arg1;
        String method = clientRequest.getMethod();
        if ("0".equals(clientRequest.getHeader("Max-Forwards"))) {
            if (method.equalsIgnoreCase("OPTIONS")) {
                this.doMyOptions(clientRequest, clientResponse);
                return;
            }
            if (method.equalsIgnoreCase("TRACE")) {
                this.doMyTrace(clientRequest, clientResponse);
                return;
            }
        }
        URI requestOriginUri = this.getRequestOriginUri(clientRequest);
        String viaProxy = this.getViaServer(clientRequest);
        long origIfModSinceMillis = clientRequest.getDateHeader("If-Modified-Since");
        Date origIfModSince = null;
        if (origIfModSinceMillis >= 0L) {
            origIfModSince = new Date(origIfModSinceMillis);
        }
        BasicHttpEntityEnclosingRequest proxyRequest = this.buildProxyRequest(clientRequest);
        String requestURI = proxyRequest.getRequestLine().getUri();
        String cacheKey = this.cache.getCacheKey(proxyRequest);
        boolean bl = useCache = !"HEAD".equalsIgnoreCase(method) && this.isCachableUri(requestURI) && this.isCacheableRequest(requestURI, clientRequest);
        if (useCache) {
            log.debug("Found potentially cachable request " + requestURI);
            ProxyResponse cachedResponse = null;
            try {
                cachedResponse = this.cache.getCachedResponseForRequest(cacheKey);
                if (cachedResponse != null) {
                    Date cachedLastModified = cachedResponse.getLastModified();
                    log.debug("Found cachable request with date " + cachedLastModified + " " + cacheKey);
                    if (origIfModSince == null || cachedLastModified.after(origIfModSince)) {
                        DateFormat fmt = ProxyResponse.newHeaderDateFormat();
                        String newLastMod = fmt.format(cachedLastModified);
                        log.debug("Using if-modified-since with date " + cachedLastModified + " " + cacheKey);
                        proxyRequest.setHeader("If-Modified-Since", newLastMod);
                    }
                }
            }
            finally {
                if (cachedResponse != null) {
                    cachedResponse.close();
                }
            }
        }
        CloseableHttpClientBuilder builder = new CloseableHttpClientBuilder();
        builder.setMaxConns(100);
        builder.setMaxConnsPerRoute(100);
        builder.setTimeoutMillis(PROXY_REQUEST_TIMEOUT_MILLIS);
        HttpClientBuilder clientBuilder = builder.buildClientBuilder();
        clientBuilder.setRedirectStrategy(NO_FOLLOW_REDIRECT);
        CloseableHttpClient proxyHttp = clientBuilder.build();
        try {
            HttpHost target = new HttpHost(this.targetUri.getHost(), this.targetUri.getPort(), this.targetUri.getScheme());
            CloseableHttpResponse serverResponse = proxyHttp.execute(target, proxyRequest);
            try {
                ProxyResponse proxyResponse = new ProxyResponseFactory().fromCloseableHttpResponse(serverResponse);
                if (useCache) {
                    ProxyResponse responseFromCache = null;
                    if (this.shouldUpdateCache(serverResponse)) {
                        log.debug("Updating cache with request: " + proxyRequest + ", response: " + serverResponse);
                        this.cache.storeCachedResponseForRequest(cacheKey, proxyResponse);
                        responseFromCache = this.cache.getCachedResponseForRequest(cacheKey);
                    } else if (proxyResponse.getStatusCode() == 304) {
                        Date lastModified = proxyResponse.getLastModified();
                        if (origIfModSince == null || lastModified == null || lastModified.after(origIfModSince)) {
                            responseFromCache = this.cache.getCachedResponseForRequest(cacheKey);
                        }
                    }
                    if (responseFromCache != null) {
                        log.debug("Using cached response response: " + serverResponse);
                        proxyResponse = responseFromCache;
                    }
                }
                try {
                    int statusCode = proxyResponse.getStatusCode();
                    String reason = proxyResponse.getStatusReason();
                    this.setStatus(clientResponse, statusCode, reason);
                    String mimeType = proxyResponse.getMimeType();
                    Charset charset = proxyResponse.getCharset();
                    boolean rewriteEntity = "text/html".equalsIgnoreCase(mimeType) || "text/css".equalsIgnoreCase(mimeType);
                    for (ProxyResponseHeader header : proxyResponse.getHeaders()) {
                        String headerName = header.getName();
                        String headerValue = header.getValue();
                        if (headerName.equalsIgnoreCase("Location") || headerName.equalsIgnoreCase("Content-Location")) {
                            headerValue = this.replaceLocationOrigin(headerValue, requestOriginUri);
                        }
                        if (headerName.equalsIgnoreCase("Content-Type")) {
                            clientResponse.setContentType(headerValue);
                            continue;
                        }
                        if (rewriteEntity && headerName.equalsIgnoreCase("Content-Length") || SINGLE_HOP_HEADERS.contains(headerName) || PROXY_HEADERS.contains(headerName)) continue;
                        if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                            headerValue = this.rewriteSetCookie(headerValue, clientRequest);
                        }
                        clientResponse.addHeader(headerName, headerValue);
                    }
                    String via = "";
                    ProxyResponseHeader viaHeader = proxyResponse.getFirstHeader("Via");
                    if (viaHeader != null && StringUtils.isNotEmpty(viaHeader.getValue())) {
                        via = via + viaHeader.getValue() + ", ";
                    }
                    via = via + viaProxy;
                    clientResponse.setHeader("Via", via);
                    ServletOutputStream out = clientResponse.getOutputStream();
                    try {
                        InputStream entity = proxyResponse.getEntity();
                        try {
                            if (entity != null) {
                                if (rewriteEntity) {
                                    Charset htmlCharSet = ObjectUtils.defaultIfNull(charset, IO.utf8());
                                    String html = IO.readText(entity, htmlCharSet);
                                    html = this.replaceHtmlOrigin(html, requestOriginUri);
                                    IO.writeText((OutputStream)out, (CharSequence)html, htmlCharSet);
                                } else {
                                    IO.copy(entity, (OutputStream)out);
                                }
                            }
                        }
                        finally {
                            IO.close(entity);
                        }
                    }
                    finally {
                        IO.close((OutputStream)out);
                    }
                }
                finally {
                    proxyResponse.close();
                }
            }
            finally {
                serverResponse.close();
            }
        }
        finally {
            proxyHttp.close();
        }
    }

    protected URI getRequestOriginUri(HttpServletRequest request) throws ServletException {
        URI requestOriginUri;
        try {
            requestOriginUri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), request.getServletPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        return requestOriginUri;
    }

    protected BasicHttpEntityEnclosingRequest buildProxyRequest(HttpServletRequest request) throws ServletException, IOException {
        String via;
        String forwardedFor;
        String path;
        String method = request.getMethod();
        String requestURI = request.getRequestURI();
        String requestContentType = request.getContentType();
        int contentLength = request.getContentLength();
        String servletPath = request.getServletPath();
        String targetPath = path = StringUtils.removeStart(requestURI, servletPath);
        if (request.getQueryString() != null) {
            targetPath = targetPath + "?" + request.getQueryString();
        }
        BasicHttpEntityEnclosingRequest proxyRequest = new BasicHttpEntityEnclosingRequest(method, targetPath);
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            if (SINGLE_HOP_HEADERS.contains(headerName) || PROXY_HEADERS.contains(headerName)) continue;
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
        String maxForwards = request.getHeader("Max-Forwards");
        if (maxForwards != null) {
            try {
                int maxRemaining = Math.max(Integer.parseInt(maxForwards, 10) - 1, 0);
                proxyRequest.addHeader("Max-Forwards", String.valueOf(maxRemaining));
            }
            catch (NumberFormatException nfe) {
                log.debug("Bad Max-Forwards header " + nfe, nfe);
            }
        }
        if (StringUtils.isEmpty(forwardedFor = StringUtils.defaultString(request.getHeader("X-Forwarded-For")))) {
            forwardedFor = request.getRemoteHost();
        }
        forwardedFor = forwardedFor + ", " + request.getServerName();
        proxyRequest.addHeader("X-Forwarded-For", forwardedFor);
        if (request.getHeader("X-Forwarded-Host") == null) {
            proxyRequest.addHeader("X-Forwarded-Host", request.getServerName());
        }
        if (request.getHeader("X-Forwarded-Proto") == null) {
            proxyRequest.addHeader("X-Forwarded-Proto", request.getScheme());
        }
        if (StringUtils.isNotEmpty(via = StringUtils.defaultString(request.getHeader("Via")))) {
            via = via + ", ";
        }
        via = via + this.getViaServer(request);
        proxyRequest.addHeader("Via", via);
        ContentType requestMime = null;
        if (requestContentType != null) {
            requestMime = ContentType.parse(requestContentType);
        }
        InputStreamEntity entity = new InputStreamEntity((InputStream)request.getInputStream(), contentLength, requestMime);
        proxyRequest.setEntity(entity);
        return proxyRequest;
    }

    private String getViaServer(HttpServletRequest clientRequest) {
        String viaProxy = clientRequest.getProtocol() + " " + clientRequest.getServerName() + ":" + clientRequest.getServerPort();
        return viaProxy;
    }

    private void setStatus(HttpServletResponse response, int status, String reason) {
        response.setStatus(status, reason);
    }

    String replaceLocationOrigin(String content, URI requestOriginUri) {
        String result = content;
        String path = this.targetUri.getPath();
        String newPath = requestOriginUri.getPath();
        if (path.endsWith("/") && !newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        String uri = this.targetUri.toString();
        String newUri = requestOriginUri.toString();
        if (uri.endsWith("/") && !newUri.endsWith("/")) {
            newUri = newUri + "/";
        }
        if (result.startsWith(path)) {
            result = result.replace(path, newPath);
        }
        if (result.startsWith(uri)) {
            result = result.replace(uri, newUri);
        }
        return result;
    }

    String replaceHtmlOrigin(String content, URI requestOriginUri) {
        String result = content;
        String path = this.targetUri.getPath();
        String newPath = requestOriginUri.getPath();
        if (path.endsWith("/") && !newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        String uri = this.targetUri.toString();
        String newUri = requestOriginUri.toString();
        if (uri.endsWith("/") && !newUri.endsWith("/")) {
            newUri = newUri + "/";
        }
        result = result.replace("href=\"" + uri, "href=\"" + newUri);
        result = result.replace("href=\"" + path, "href=\"" + newPath);
        result = result.replace("src=\"" + uri, "src=\"" + newUri);
        result = result.replace("src=\"" + path, "src=\"" + newPath);
        result = result.replace("action=\"" + uri, "action=\"" + newUri);
        result = result.replace("action=\"" + path, "action=\"" + newPath);
        result = result.replace("url(\"" + uri, "url(\"" + newUri);
        result = result.replace("url(\"" + path, "url(\"" + newPath);
        result = result.replace("url('" + uri, "url('" + newUri);
        result = result.replace("url('" + path, "url('" + newPath);
        result = result.replace("url(" + uri, "url(" + newUri);
        result = result.replace("url(" + path, "url(" + newPath);
        return result;
    }

    String rewriteSetCookie(String headerValue, HttpServletRequest clientRequest) {
        String resultHeaderValue = headerValue;
        if (!clientRequest.isSecure()) {
            resultHeaderValue = resultHeaderValue.replace(" Secure;", "");
        }
        resultHeaderValue = resultHeaderValue.replaceAll("(?i)domain=([^;]+;)", "");
        String contextPath = this.getServletContext().getContextPath();
        if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        String targetPath = this.targetUri.getPath();
        resultHeaderValue = resultHeaderValue.replace("path=" + targetPath, "path=" + contextPath);
        log.trace("Rewrote set-cookie header \"" + headerValue + "\" to \"" + resultHeaderValue);
        return resultHeaderValue;
    }

    boolean isCachableUri(String uriPath) {
        boolean result = false;
        for (Pattern p : this.cachePatterns) {
            if (!p.matcher(uriPath).matches()) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean isCacheableRequest(String requestUri, HttpServletRequest clientRequest) {
        boolean hasEntityData;
        String clientContentType = clientRequest.getContentType();
        int contentLength = clientRequest.getContentLength();
        String traceMsg = String.format("[uri=%s, Content-Type=%s, Content-Length=%s]", requestUri, clientContentType, contentLength);
        if (contentLength == 0) {
            log.trace("Request has empty content entity " + traceMsg);
            hasEntityData = false;
        } else if (clientContentType == null) {
            log.trace("Request has empty content entity, " + traceMsg);
            hasEntityData = false;
        } else if (contentLength == -1) {
            hasEntityData = true;
        } else {
            hasEntityData = true;
            if (clientContentType.startsWith("multipart/")) {
                ContentType clientMime = ContentType.parse(clientContentType);
                String boundary = clientMime.getParameter("boundary");
                String termBoundary = "--" + boundary + "--\r\n";
                if (termBoundary.length() >= contentLength) {
                    log.trace("Request has empty multi-part content entity, " + traceMsg);
                    hasEntityData = false;
                }
            }
        }
        if (hasEntityData) {
            log.debug("Request has non-empty content entity, not cachable by proxy, " + traceMsg);
        }
        return !hasEntityData;
    }

    boolean shouldUpdateCache(CloseableHttpResponse response) {
        boolean cacheableStatus;
        for (Header h : response.getHeaders("Cache-Control")) {
            String headerValue = h.getValue();
            if (!headerValue.equalsIgnoreCase("no-cache") && !headerValue.equalsIgnoreCase("no-store") && !headerValue.equalsIgnoreCase("private")) continue;
            return false;
        }
        boolean bl = cacheableStatus = response.getStatusLine().getStatusCode() == 200 && response.containsHeader("Last-Modified");
        if (cacheableStatus && response.containsHeader("Set-Cookie")) {
            log.debug("Response included set-cookie, may not be cached");
            return false;
        }
        return cacheableStatus;
    }

    protected void doMyOptions(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setHeader("ALLOW", "DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE");
        httpResponse.setStatus(204);
        IO.close((OutputStream)httpResponse.getOutputStream());
    }

    protected void doMyTrace(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String CRLF = "\r\n";
        StringBuilder buffer = new StringBuilder("TRACE ").append(httpRequest.getRequestURI()).append(" ").append(httpRequest.getProtocol());
        Enumeration reqHeaderEnum = httpRequest.getHeaderNames();
        while (reqHeaderEnum.hasMoreElements()) {
            String headerName = (String)reqHeaderEnum.nextElement();
            buffer.append("\r\n").append(headerName).append(": ").append(httpRequest.getHeader(headerName));
        }
        buffer.append("\r\n");
        int responseLength = buffer.length();
        httpResponse.setContentType("message/http");
        httpResponse.setContentLength(responseLength);
        ServletOutputStream out = httpResponse.getOutputStream();
        out.print(buffer.toString());
        out.close();
    }

    static {
        SINGLE_HOP_HEADERS.addAll(Arrays.asList("Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"));
        PROXY_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        PROXY_HEADERS.addAll(Arrays.asList("X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Proto", "Max-Forwards", "Host", "Content-Length", "Via"));
        NO_FOLLOW_REDIRECT = new RedirectStrategy(){

            public boolean isRedirected(HttpRequest arg0, HttpResponse arg1, HttpContext arg2) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest arg0, HttpResponse arg1, HttpContext arg2) throws ProtocolException {
                return null;
            }
        };
    }
}

