/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.web.WebException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHandler {
    private static final Logger logger = Logger.getLogger(RequestHandler.class);
    private final HttpServletRequest request;
    private final Hashtable<String, Vector<Object>> params;

    RequestHandler(HttpServletRequest request) throws WebException {
        this.request = request;
        this.params = this.parseRequest(request);
    }

    private Hashtable<String, Vector<Object>> parseRequest(HttpServletRequest request) throws WebException {
        Hashtable<String, Vector<Object>> params = new Hashtable<String, Vector<Object>>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            try {
                List fileItemsList = new ServletFileUpload((FileItemFactory)factory).parseRequest(request);
                for (FileItem fileItem : fileItemsList) {
                    String name = fileItem.getFieldName();
                    if (!params.containsKey(name)) {
                        params.put(name, new Vector());
                        params.put(name + "_filename", new Vector());
                    }
                    if (fileItem.isFormField()) {
                        try {
                            params.get(name).addElement(fileItem.getString("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("This should never happen", e);
                        }
                        continue;
                    }
                    if (fileItem.getSize() <= 0L) continue;
                    params.get(name + "_filename").addElement(new File(fileItem.getName()).getName());
                    params.get(name).addElement(fileItem);
                }
            }
            catch (FileUploadException e) {
                throw new WebException(e);
            }
        } else {
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                if (!params.containsKey(name)) {
                    params.put(name, new Vector());
                }
                for (String value : request.getParameterValues(name)) {
                    params.get(name).addElement(value);
                }
            }
        }
        return params;
    }

    public String getString(String name) {
        String result = null;
        if (this.params.containsKey(name) && (result = this.params.get(name).firstElement().toString()) != null && (result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    public FileItem getFileItem(String name) {
        FileItem result = null;
        if (this.params.containsKey(name) && !this.params.get(name).isEmpty()) {
            result = (FileItem)this.params.get(name).firstElement();
        }
        return result;
    }

    public FileItem[] getFileItemArray(String name) {
        FileItem[] result = null;
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        if (this.params.containsKey(name)) {
            for (Object object : this.params.get(name)) {
                fileItems.add((FileItem)object);
            }
        }
        if (!fileItems.isEmpty()) {
            result = fileItems.toArray(new FileItem[0]);
        }
        return result;
    }

    public FileItem[] getFileItemArrayByPrefix(String namePrefix) {
        FileItem[] result = null;
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        for (String paramName : this.params.keySet()) {
            if (!paramName.startsWith(namePrefix)) continue;
            for (Object object : this.params.get(paramName)) {
                if (!(object instanceof FileItem)) continue;
                fileItems.add((FileItem)object);
            }
        }
        if (!fileItems.isEmpty()) {
            result = fileItems.toArray(new FileItem[0]);
        }
        return result;
    }

    public Long getLong(String name) {
        Long result = null;
        if (this.params.containsKey(name)) {
            try {
                result = Long.parseLong(this.params.get(name).firstElement().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Long[] getLongArray(String name) {
        Long[] result = null;
        ArrayList<Long> longs = new ArrayList<Long>();
        if (this.params.containsKey(name)) {
            for (Object object : this.params.get(name)) {
                try {
                    longs.add(Long.parseLong(object.toString()));
                }
                catch (NumberFormatException exc) {}
            }
        }
        if (!longs.isEmpty()) {
            result = longs.toArray(new Long[0]);
        }
        return result;
    }

    public Double getDouble(String name) {
        Double result = null;
        if (this.params.containsKey(name)) {
            try {
                result = Double.parseDouble(this.params.get(name).firstElement().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Integer getInteger(String name) {
        Integer result = null;
        if (this.params.containsKey(name)) {
            try {
                result = Integer.parseInt(this.params.get(name).firstElement().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Boolean getBoolean(String name) {
        Boolean result = false;
        if (this.params.containsKey(name)) {
            result = Boolean.parseBoolean(this.params.get(name).firstElement().toString());
        }
        return result;
    }

    public String[] getStringArray(String name) {
        String[] result = null;
        if (this.params.containsKey(name)) {
            result = this.params.get(name).toArray(new String[0]);
        }
        return result;
    }

    public Date getDate(String name) {
        Date result = null;
        if (this.params.containsKey(name)) {
            try {
                String format = "yyyy-MM-dd";
                String dateString = this.params.get(name).firstElement().toString();
                if (!dateString.equals(format)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    result = dateFormat.parse(dateString);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public URL getUrl(String name, String protocolPrefixIfEmpty) {
        URL result = null;
        String urlString = this.getString(name);
        if (!StringUtils.isEmpty(urlString) && !urlString.toLowerCase().startsWith(protocolPrefixIfEmpty.toLowerCase())) {
            urlString = protocolPrefixIfEmpty + urlString;
        }
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return result;
    }

    public String toString() {
        return this.params.toString();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Map<String, Vector<Object>> getParameterMap() {
        return this.params;
    }
}

