/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.text.DecimalFormatSymbols;
import java.util.Formatter;
import java.util.Locale;

@BridgeMethodsAdded
public class DbProfile {
    private final long executeCount;
    private final long commitCount;
    private final long rollbackCount;
    private final long executeTimeNanos;
    private final long commitTimeNanos;
    private final long rollbackTimeNanos;

    DbProfile(long executeCount, long commitCount, long rollbackCount, long executeTimeNanos, long commitTimeNanos, long rollbackTimeNanos) {
        this.executeCount = executeCount;
        this.commitCount = commitCount;
        this.rollbackCount = rollbackCount;
        this.executeTimeNanos = executeTimeNanos;
        this.commitTimeNanos = commitTimeNanos;
        this.rollbackTimeNanos = rollbackTimeNanos;
    }

    public long getExecuteCount() {
        return this.executeCount;
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public long getExecuteTimeNanos() {
        return this.executeTimeNanos;
    }

    public long getCommitTimeNanos() {
        return this.commitTimeNanos;
    }

    public long getRollbackTimeNanos() {
        return this.rollbackTimeNanos;
    }

    public long getTotalTimeNanos() {
        return this.executeTimeNanos + this.commitTimeNanos + this.rollbackTimeNanos;
    }

    public String toString() {
        Formatter formatter = new Formatter(Locale.US);
        this.toString(formatter);
        return formatter.toString();
    }

    public void toString(Formatter formatter) {
        formatter.format("Ex=%,d, ", this.getExecuteCount());
        this.formatSeconds(formatter, this.getExecuteTimeNanos());
        formatter.format("; Cm=%,d, ", this.getCommitCount());
        this.formatSeconds(formatter, this.getCommitTimeNanos());
        formatter.format("; Rb=%,d, ", this.getRollbackCount());
        this.formatSeconds(formatter, this.getRollbackTimeNanos());
        formatter.format("; Tt=", new Object[0]);
        this.formatSeconds(formatter, this.getTotalTimeNanos());
    }

    private void formatSeconds(Formatter formatter, long nanos) {
        long millis = nanos / 1000000L;
        char decimal = '.';
        Locale locale = formatter.locale();
        if (locale != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            decimal = symbols.getDecimalSeparator();
        }
        formatter.format("%,d%c%03d", millis / 1000L, Character.valueOf(decimal), millis % 1000L);
    }
}

