/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ObjectPool;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

@BridgeMethodsAdded
public class ThreadPool
extends ObjectPool {
    protected static final Logger log = Logger.getLogger(ThreadPool.class);
    private static final Set<WeakReference<ThreadPool>> threadPoolSet = Collections.synchronizedSet(new HashSet());
    private String name = "ThreadPool";
    private int threadId = 0;
    private ThreadGroup threadGroup = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool[] getThreadPoolArray() {
        ArrayList<ThreadPool> result = new ArrayList<ThreadPool>();
        Set<WeakReference<ThreadPool>> set = threadPoolSet;
        synchronized (set) {
            ArrayList<WeakReference<ThreadPool>> staleReferences = new ArrayList<WeakReference<ThreadPool>>();
            for (WeakReference<ThreadPool> reference : threadPoolSet) {
                ThreadPool pool = (ThreadPool)reference.get();
                if (pool == null) {
                    staleReferences.add(reference);
                    continue;
                }
                result.add(pool);
            }
            threadPoolSet.removeAll(staleReferences);
        }
        return result.toArray(new ThreadPool[result.size()]);
    }

    private static void addThreadPool(ThreadPool target) {
        threadPoolSet.add(new WeakReference<ThreadPool>(target));
    }

    public ThreadPool() {
        ThreadPool.addThreadPool(this);
    }

    public ThreadPool(String name, int minThreadCount, int maxThreadCount, int cleanUpInterval, int expirationTime) {
        super(minThreadCount, maxThreadCount, cleanUpInterval, expirationTime);
        this.name = name;
        this.threadGroup = new ThreadGroup(name);
        ThreadPool.addThreadPool(this);
    }

    public String getName() {
        return this.name;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void run(Runnable runnable) {
        log.debug("ThreadPool requested to run runnable: " + runnable);
        if (!this.isInitialized()) {
            throw new IllegalStateException("ThreadPool not running.");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable can not be null.");
        }
        WorkerThread worker = (WorkerThread)this.checkOut();
        worker.run(runnable);
    }

    public void shutdown() {
        super.shutdown();
        for (Object obj : this.coObjectSet) {
            if (!(obj instanceof WorkerThread)) continue;
            ((WorkerThread)obj).shutdown();
        }
    }

    protected Object getNewInstance() {
        WorkerThread wt = new WorkerThread(this.threadGroup, this.name + "-" + this.threadId++);
        log.debug("WorkerThread " + wt.getName() + " created");
        wt.start();
        return wt;
    }

    protected void expire(Object o) throws Exception {
        WorkerThread worker = (WorkerThread)o;
        worker.shutdown();
    }

    protected boolean isObjectValid(Object o) throws Exception {
        WorkerThread worker = (WorkerThread)o;
        return worker.isAlive() && !worker.isInterrupted() && worker.isValid;
    }

    @BridgeMethodsAdded
    class WorkerThread
    extends Thread {
        private boolean isTerminated;
        private Runnable runnable;
        private boolean isValid;

        WorkerThread(ThreadGroup threadGroup, String name) {
            super(threadGroup, name);
            this.isTerminated = false;
            this.runnable = null;
            this.isValid = true;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isTerminated) {
                try {
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (!this.isTerminated && this.runnable == null) {
                            log.debug("Runnable is null, WorkerThread " + super.getName() + " is waiting.");
                            this.wait();
                        }
                    }
                    if (this.isTerminated) break;
                    if (this.runnable == null) continue;
                    log.debug("WorkerThread " + super.getName() + " got runnable: " + this.runnable);
                    try {
                        this.runnable.run();
                    }
                    catch (Throwable t) {
                        this.isValid = false;
                        log.error(t.getMessage(), t);
                    }
                    finally {
                        this.runnable = null;
                        log.debug("" + super.getName() + " checking itself in");
                        ThreadPool.this.checkIn(this);
                    }
                }
                catch (InterruptedException ie) {
                    log.error(ie.getMessage(), ie);
                }
            }
            log.debug("WorkerThread " + super.getName() + " shutdown complete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(Runnable runnable) {
            log.debug("WorkerThread " + super.getName() + " requested to run runnable: " + runnable);
            if (runnable == null) {
                throw new IllegalArgumentException("Runnable is null.");
            }
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.runnable != null) {
                    // empty if block
                }
                this.runnable = runnable;
                this.notify();
            }
        }

        protected synchronized void shutdown() {
            log.debug("WorkerThread " + super.getName() + " requested to shutdown");
            this.isTerminated = true;
            this.notifyAll();
        }
    }
}

