/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class PerformanceTimer {
    private static PerformanceTimer instance = new PerformanceTimer();
    Map<String, Long> timeAccumulated = new HashMap<String, Long>();
    Map<String, Long> counters = new HashMap<String, Long>();
    Map<Thread, Map<String, Long>> threadTimersStarted = new HashMap<Thread, Map<String, Long>>();

    public static PerformanceTimer getInstance() {
        return instance;
    }

    public void start(String name) {
        Map<String, Long> timersStarted = this.getThreadTimers();
        Long existingStart = timersStarted.get(name);
        if (existingStart == null) {
            timersStarted.put(name, System.currentTimeMillis());
        }
    }

    public void stop(String name) {
        Map<String, Long> timersStarted = this.getThreadTimers();
        Long existingStart = timersStarted.remove(name);
        if (existingStart != null) {
            Long now = System.currentTimeMillis();
            Long duration = now - existingStart;
            Long totalDuration = this.timeAccumulated.get(name);
            if (totalDuration == null) {
                totalDuration = 0L;
            }
            totalDuration = totalDuration + duration;
            this.timeAccumulated.put(name, totalDuration);
            Long existingCounter = this.counters.get(name);
            if (existingCounter == null) {
                existingCounter = 0L;
            }
            Long l = existingCounter;
            Long l2 = existingCounter = Long.valueOf(existingCounter + 1L);
            this.counters.put(name, existingCounter);
        }
    }

    private Map<String, Long> getThreadTimers() {
        Map<String, Long> timersStarted = this.threadTimersStarted.get(Thread.currentThread());
        if (timersStarted == null) {
            timersStarted = new HashMap<String, Long>();
            this.threadTimersStarted.put(Thread.currentThread(), timersStarted);
        }
        return timersStarted;
    }

    public void report() {
        ArrayList<String> names = new ArrayList<String>(this.timeAccumulated.keySet());
        Collections.sort(names);
        for (String name : names) {
            Long duration = this.timeAccumulated.get(name);
            Long counter = this.counters.get(name);
            System.out.println(name + ": " + duration + " total / " + duration / counter + " avg in " + counter + " periods");
        }
    }

    public void clear() {
        this.timeAccumulated.clear();
        this.threadTimersStarted.clear();
        this.counters.clear();
    }
}

