/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.digest;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.util.IO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class DigestProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File baseDir = null;
    private File digestFile = null;
    private Properties props = new Properties();

    public DigestProperties() {
    }

    public DigestProperties(File digestFile) {
        this.digestFile = digestFile;
        this.baseDir = digestFile.getParentFile();
        this.readProperties();
    }

    public DigestProperties(File digestFile, File baseDir) {
        this.digestFile = digestFile;
        this.baseDir = baseDir;
        this.readProperties();
    }

    public DigestProperties(InputStream in, File baseDir) {
        this.baseDir = baseDir;
        this.readProperties(in);
    }

    private void readProperties(InputStream in) {
        try {
            this.props.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readProperties() {
        if (this.digestFile.exists() && this.digestFile.isFile()) {
            BufferedInputStream in = null;
            try {
                in = IO.buffer(new FileInputStream(this.digestFile));
                this.props.load(in);
            }
            catch (IOException iOException) {
                IO.closeNoThrow(in);
                catch (Throwable throwable) {
                    IO.closeNoThrow(in);
                    throw throwable;
                }
            }
            IO.closeNoThrow(in);
        }
    }

    private String getPropertyName(File file) {
        return FileUtils.getRelativeFileName(this.baseDir, file).replace(File.separatorChar, '/');
    }

    public void addAllProperties(DigestProperties otherProps) {
        this.props.putAll((Map<?, ?>)otherProps.props);
    }

    public File[] getFileArray() {
        ArrayList<File> fileList = new ArrayList<File>();
        Enumeration<Object> keyEnum = this.props.keys();
        while (keyEnum.hasMoreElements()) {
            String fileName = (String)keyEnum.nextElement();
            File file = new File(this.baseDir, fileName.replace('/', File.separatorChar));
            fileList.add(file);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public String getDigestInfo(File file) {
        return this.props.getProperty(this.getPropertyName(file));
    }

    public String getDigestInfo(String fileName) {
        return fileName == null ? null : this.props.getProperty(fileName);
    }

    public void setDigestInfo(File file, String digestInfo) {
        if (this.baseDir == null) {
            throw new IllegalStateException("baseDir not set");
        }
        if (!this.digestFile.equals(file)) {
            this.setDigestInfo(this.getPropertyName(file), digestInfo);
        }
    }

    public void setDigestInfo(String pathname, String digestInfo) {
        this.props.setProperty(pathname, digestInfo);
    }

    public void removeDigestInfo(File file) {
        this.props.remove(this.getPropertyName(file));
    }

    public String[] getFileNameArray() {
        return this.props.keySet().toArray(new String[this.props.size()]);
    }

    public void store() throws IOException {
        if (this.digestFile == null) {
            throw new IllegalStateException("digest file not set");
        }
        this.store(this.digestFile);
    }

    public void store(OutputStream out) throws IOException {
        this.props.store(out, "Anthill3 Artifacts Digest File");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        OutputStream out = new FileOutputStream(file);
        try {
            out = new BufferedOutputStream(out);
            this.store(out);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

