/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.xml;

import com.urbancode.air.plugin.server.ext.PluginCommandType;
import com.urbancode.air.plugin.server.ext.PluginDependency;
import com.urbancode.air.plugin.server.ext.PluginExtension;
import com.urbancode.air.plugin.server.ext.PluginPropertyGroup;
import com.urbancode.air.plugin.server.ext.PluginType;
import com.urbancode.air.plugin.server.ext.PropertyGroupProperty;
import com.urbancode.air.plugin.server.ext.PropertyGroupPropertyUI;
import com.urbancode.air.plugin.server.ext.PropertyGroupPropertyUIType;
import com.urbancode.air.plugin.server.ext.PropertyGroupType;
import com.urbancode.air.plugin.server.ud.ext.UDCommandExtension;
import com.urbancode.air.plugin.server.ud.ext.UDPluginPropertyGroup;
import com.urbancode.air.plugin.server.ud.ext.UDPluginPropertyGroupSpecialType;
import com.urbancode.air.plugin.server.xml.ServerPluginXMLContentHandler;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.properties.SelectValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UDServerPluginXMLContentHandler
extends ServerPluginXMLContentHandler {
    public static final String PROPERTY_GROUP_ELEMENT = "property-group";
    public static final String TYPE_ELEMENT = "type";
    public static final String ROLE_ELEMENT = "role";
    public static final String ROLES_ELEMENT = "roles";
    public static final String SPECIAL_TYPE = "specialType";
    public static final String DEFAULT_PROPERTY_NAME_ATTRIBUTE = "default-name-property";
    public static final String PLUGIN_TYPE_ELEMENT = "plugin-type";
    public static final String SUB_TAG_ELEMENT = "sub-tag";
    public static final String ALLOWED_PARENT_ROLES_ELEMENT = "allowed-parent-roles";
    public static final String ALLOWED_PARENT_ROLE_ELEMENT = "allowed-parent-role";
    public static final String FOLDER_NAME_ELEMENT = "folder-name";
    public static final String ALLOWED_ROLE_NAME_ELEMENT = "allowed-role-name";
    public static final String DEFAULT_CHILD_FOLDERS_ELEMENT = "default-child-folders";
    public static final String DEFAULT_CHILD_FOLDER_ELEMENT = "default-child-folder";
    public static final String ALLOWED_NAMES_ELEMENT = "allowed-names";
    public static final String ALLOWED_NAME_ELEMENT = "allowed-name";
    public static final String DEPENDENCIES_ELEMENT = "dependencies";
    public static final String DEPENDENCY_ELEMENT = "dependency";
    public static final String DEPENDENCY_ID_ATTRIBUTE = "plugin-id";
    public static final String DEPENDENCY_MIN_VERSION_ATTRIBUTE = "min-version";
    PropertyGroupProperty curGroupProp = null;
    UDPluginPropertyGroup curGroup = null;
    List<PluginPropertyGroup> propGroups = new ArrayList<PluginPropertyGroup>();
    Set<PluginDependency> deps = new HashSet<PluginDependency>();
    boolean groupHasProp = false;
    protected List<String> curRoleNames;
    protected Set<String> folderNames;
    protected String curAllowedRoleName = null;
    protected Set<String> curAllowedResourceNames = null;
    boolean hasType = false;
    boolean hasRoles = false;
    String subTag = null;
    boolean hasSubTag = false;
    PluginType pluginType;

    public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.equals(PROPERTY_GROUP_ELEMENT)) {
            this.handlePropertyGroupStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(TYPE_ELEMENT)) {
            this.handleTypeStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ROLE_ELEMENT)) {
            this.handleRoleStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ROLES_ELEMENT)) {
            this.handleRolesStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(PLUGIN_TYPE_ELEMENT)) {
            this.handlePluginTypeStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(SUB_TAG_ELEMENT)) {
            this.handleSubTagStart(attrs);
            this.tagNameStack.push(localName);
        } else if (localName.equals(ALLOWED_PARENT_ROLES_ELEMENT)) {
            this.handleAllowedParentRolesStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ALLOWED_PARENT_ROLE_ELEMENT)) {
            this.handleAllowedParentRoleStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ALLOWED_ROLE_NAME_ELEMENT)) {
            this.handleAllowedRoleNameStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(DEFAULT_CHILD_FOLDERS_ELEMENT)) {
            this.handleDefaultChildFoldersStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(DEFAULT_CHILD_FOLDER_ELEMENT)) {
            this.handleDefaultChildFolderStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ALLOWED_NAMES_ELEMENT)) {
            this.handleAllowedNamesStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(ALLOWED_NAME_ELEMENT)) {
            this.handleAllowedNameStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(FOLDER_NAME_ELEMENT)) {
            this.handleFolderNameStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(DEPENDENCIES_ELEMENT)) {
            this.handleDependenciesStart(attrs);
            this.tagNameStack.push(localName);
        } else if (localName.equals(DEPENDENCY_ELEMENT)) {
            this.handleDependencyStart(attrs);
            this.tagNameStack.push(localName);
        } else {
            super.startElement(ns, localName, qName, attrs);
        }
    }

    public void endElement(String ns, String localName, String qName) throws SAXException {
        if (localName.equals(PROPERTY_GROUP_ELEMENT)) {
            this.handlePropertyGroupEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(TYPE_ELEMENT)) {
            this.handleTypeEnd();
            this.tagNameStack.pop();
        } else if (localName.equals("description")) {
            this.handleDescriptionEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(ROLE_ELEMENT)) {
            this.handleRoleEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(PLUGIN_TYPE_ELEMENT)) {
            this.handlePluginTypeEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(SUB_TAG_ELEMENT)) {
            this.handleSubTagEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(ALLOWED_PARENT_ROLE_ELEMENT)) {
            this.handleAllowedParentRoleEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(ALLOWED_ROLE_NAME_ELEMENT)) {
            this.handleAllowedRoleNameEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(DEFAULT_CHILD_FOLDER_ELEMENT)) {
            this.handleDefaultChildFolderEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(ALLOWED_NAME_ELEMENT)) {
            this.handleAllowedNameEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(FOLDER_NAME_ELEMENT)) {
            this.handleFolderNameEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(DEPENDENCIES_ELEMENT)) {
            this.handleDependenciesEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(DEPENDENCY_ELEMENT)) {
            this.handleDependencyEnd();
            this.tagNameStack.pop();
        } else {
            super.endElement(ns, localName, qName);
        }
    }

    protected void handleDependenciesStart(Attributes atts) throws SAXException {
        this.checkParentElementType(new String[]{"header"}, DEPENDENCIES_ELEMENT);
        if (atts.getLength() > 0) {
            throw new SAXException("dependencies should have no attributes");
        }
    }

    protected void handleDependenciesEnd() throws SAXException {
    }

    protected void handleDependencyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{DEPENDENCIES_ELEMENT}, DEPENDENCY_ELEMENT);
        String id = null;
        Integer minVersion = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String locName = attrs.getLocalName(i);
            if (locName.equals(DEPENDENCY_ID_ATTRIBUTE)) {
                id = attrs.getValue(i);
                continue;
            }
            if (locName.equals(DEPENDENCY_MIN_VERSION_ATTRIBUTE)) {
                try {
                    minVersion = Integer.parseInt(attrs.getValue(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException("min-version attribute on dependency is not a valid Integer.");
                }
            }
            throw new SAXException("Attribute " + locName + " not valide for element " + DEPENDENCY_ELEMENT);
        }
        this.deps.add(new PluginDependency(id, minVersion));
    }

    protected void handleDependencyEnd() throws SAXException {
    }

    protected void handleHeaderEnd() throws SAXException {
        PluginExtension ext = null;
        ext = PluginType.Source.equals((Object)this.pluginType) ? new PluginExtension(PluginType.Source) : new PluginExtension(PluginType.Automation);
        for (PluginDependency dep : this.deps) {
            ext.addPluginDependency(dep);
        }
        super.handleHeaderEnd();
        this.plugin.setExtension((Extension)ext);
    }

    protected void handlePropertyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{"properties", PROPERTY_GROUP_ELEMENT}, "property");
        if (((String)this.tagNameStack.peek()).equals(PROPERTY_GROUP_ELEMENT)) {
            String name = null;
            Boolean required = false;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getLocalName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals("name")) {
                    name = attrValue;
                    continue;
                }
                if (attrName.equals("required")) {
                    required = Boolean.valueOf(attrValue);
                    continue;
                }
                throw new SAXException("Unknown attribute on property element " + attrName);
            }
            if (name == null) {
                throw new SAXException("name is a required attribute on property");
            }
            PropertyGroupProperty prop = new PropertyGroupProperty(name, required.booleanValue(), null);
            this.curGroup.addProperty(prop);
            this.curGroupProp = prop;
        } else {
            super.handlePropertyStart(attrs);
        }
    }

    protected void handlePropertyEnd() throws SAXException {
        super.handlePropertyEnd();
        this.curGroupProp = null;
    }

    protected void handlePropertyUIStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("property", "property-ui");
        if (((String)this.tagNameStack.get(this.tagNameStack.size() - 2)).equals(PROPERTY_GROUP_ELEMENT)) {
            PropertyGroupPropertyUIType type = null;
            String label = null;
            String description = null;
            String placeholder = null;
            String defaultValue = null;
            Boolean hidden = false;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getLocalName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals("label")) {
                    label = attrValue;
                    continue;
                }
                if (attrName.equals("description")) {
                    description = attrValue.replaceAll("\\s+", " ");
                    continue;
                }
                if (attrName.equals("placeholder")) {
                    placeholder = attrValue;
                    continue;
                }
                if (attrName.equals("default-value")) {
                    defaultValue = attrValue;
                    continue;
                }
                if (attrName.equals("hidden")) {
                    hidden = Boolean.valueOf(attrValue);
                    continue;
                }
                if (attrName.equals(TYPE_ELEMENT)) {
                    type = PropertyGroupPropertyUIType.valueOf((String)attrValue);
                    continue;
                }
                throw new SAXException("Unknown attribute on property-ui : " + attrName);
            }
            if (label == null) {
                label = this.curGroupProp.getName();
            }
            if (type == null) {
                throw new SAXException("type is a required attribute on property-ui");
            }
            PropertyGroupPropertyUI ui = new PropertyGroupPropertyUI(type, label, description, placeholder, defaultValue, hidden.booleanValue());
            this.curGroupProp.setPropertyUI(ui);
            this.hasPropUi = true;
        } else {
            super.handlePropertyUIStart(attrs);
        }
    }

    protected void handleValueEnd() throws SAXException {
        if (this.curGroupProp != null) {
            String val;
            this.curAllowedValueValue = val = this.tagText.toString().trim();
            SelectValue value = new SelectValue(this.curAllowedValueLabel, this.curAllowedValueValue);
            this.curGroupProp.addAllowedValue(value);
            this.curAllowedValueLabel = null;
            this.curAllowedValueValue = null;
        } else {
            super.handleValueEnd();
        }
    }

    private void handlePropertyGroupStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("plugin", PROPERTY_GROUP_ELEMENT);
        String name = null;
        PropertyGroupType type = null;
        UDPluginPropertyGroupSpecialType specType = null;
        String defaultNameProperty = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = attrValue;
                continue;
            }
            if (attrName.equals(TYPE_ELEMENT)) {
                type = PropertyGroupType.valueOf((String)attrValue);
                continue;
            }
            if (attrName.equals(SPECIAL_TYPE)) {
                specType = UDPluginPropertyGroupSpecialType.valueOf(attrValue);
                continue;
            }
            if (attrName.equals(DEFAULT_PROPERTY_NAME_ATTRIBUTE)) {
                defaultNameProperty = attrValue;
                continue;
            }
            throw new SAXException("Unknown attribute on property-group : " + attrName);
        }
        if (name == null) {
            throw new SAXException("Attribute name is required on property-group");
        }
        if (type == null) {
            throw new SAXException("Attribute type is required on property-group");
        }
        this.curGroup = new UDPluginPropertyGroup(type, specType);
        this.curGroup.setName(name);
        this.curGroup.setDefaultNameProperty(defaultNameProperty);
    }

    private void handlePropertyGroupEnd() throws SAXException {
        this.propGroups.add(this.curGroup);
        this.curGroup = null;
    }

    protected void handlePluginEnd() throws SAXException {
        super.handlePluginEnd();
        PluginExtension ext = (PluginExtension)this.plugin.getExtension();
        for (PluginPropertyGroup propGroup : this.propGroups) {
            ext.addPropertyGroup(propGroup);
        }
    }

    protected void handleTypeStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("step-type", TYPE_ELEMENT);
        if (this.hasType) {
            throw new SAXException("step-type cannot have more than one type");
        }
    }

    protected void handleTypeEnd() throws SAXException {
        String val = this.tagText.toString();
        PluginCommandType type = PluginCommandType.valueOf((String)val);
        UDCommandExtension ext = new UDCommandExtension(type, null);
        this.curCommand.setExtension((Extension)ext);
        this.hasType = true;
    }

    protected void handleRolesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("step-type", ROLES_ELEMENT);
        if (this.hasRoles) {
            throw new SAXException("step-type cannot have more than one roles");
        }
    }

    protected void handleRolesEnd() throws SAXException {
        this.hasRoles = true;
    }

    protected void handleRoleStart(Attributes attrs) throws SAXException {
        if (attrs.getLength() != 0) {
            throw new SAXException("role should not have any attributes!");
        }
    }

    protected void handleRoleEnd() throws SAXException {
        String val = this.tagText.toString();
        if (this.curRoleNames == null) {
            this.curRoleNames = new ArrayList<String>();
        }
        this.curRoleNames.add(val);
    }

    protected void handleAllowedParentRolesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PROPERTY_GROUP_ELEMENT, ALLOWED_PARENT_ROLES_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("allowed-parent-roles should not have any attributes!");
        }
    }

    protected void handleAllowedParentRoleStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(ALLOWED_PARENT_ROLES_ELEMENT, ALLOWED_PARENT_ROLE_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("allowed-parent-role should not have any attributes!");
        }
        this.folderNames = new HashSet<String>();
        this.curAllowedRoleName = null;
    }

    protected void handleAllowedParentRoleEnd() throws SAXException {
        if (this.curAllowedRoleName == null) {
            throw new SAXException("Missing required child element of allowed-parent-role : allowed-role-name");
        }
        this.curGroup.addAllowedParentRole(this.curAllowedRoleName, this.folderNames, this.curAllowedResourceNames);
        this.folderNames = null;
        this.curAllowedRoleName = null;
        this.curAllowedResourceNames = new HashSet<String>();
    }

    protected void handleAllowedRoleNameEnd() throws SAXException {
        this.curAllowedRoleName = this.tagText.toString();
    }

    protected void handleAllowedRoleNameStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(ALLOWED_PARENT_ROLE_ELEMENT, ALLOWED_ROLE_NAME_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("allowed-role-name should not have any attributes!");
        }
    }

    protected void handleFolderNameStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(ALLOWED_PARENT_ROLE_ELEMENT, FOLDER_NAME_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("folder-name should not have any attributes!");
        }
    }

    protected void handleFolderNameEnd() throws SAXException {
        this.folderNames.add(this.tagText.toString());
    }

    protected void handleDefaultChildFoldersStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PROPERTY_GROUP_ELEMENT, DEFAULT_CHILD_FOLDERS_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("default-child-folders should not have any attributes!");
        }
    }

    protected void handleDefaultChildFolderStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(DEFAULT_CHILD_FOLDERS_ELEMENT, DEFAULT_CHILD_FOLDER_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("default-child-folder should not have any attributes!");
        }
    }

    protected void handleDefaultChildFolderEnd() throws SAXException {
        String val = this.tagText.toString();
        this.curGroup.addDefaultChildFolder(val);
    }

    protected void handleAllowedNamesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(ALLOWED_PARENT_ROLE_ELEMENT, ALLOWED_NAMES_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("allowed-names should not have any attributes!");
        }
        this.curAllowedResourceNames = new HashSet<String>();
    }

    protected void handleAllowedNameStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(ALLOWED_NAMES_ELEMENT, ALLOWED_NAME_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("allowed-name should not have any attributes!");
        }
    }

    protected void handleAllowedNameEnd() throws SAXException {
        String val = this.tagText.toString();
        this.curAllowedResourceNames.add(val);
    }

    protected void handleSubTagStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("step-type", SUB_TAG_ELEMENT);
        if (this.hasSubTag) {
            throw new SAXException("step-type cannot have more than one sub-tag");
        }
        if (attrs.getLength() != 0) {
            throw new SAXException("sub-tag should not have any attributes!");
        }
    }

    protected void handleSubTagEnd() throws SAXException {
        String val = this.tagText.toString().trim();
        if (this.curCommand.getExtension() != null) {
            ((UDCommandExtension)this.curCommand.getExtension()).setSubTag(val);
        }
        this.subTag = val;
        this.hasSubTag = true;
    }

    protected void handleDescriptionEnd() throws SAXException {
        String grandParentElementName = (String)this.tagNameStack.get(this.tagNameStack.size() - 2);
        if (grandParentElementName.equals(PROPERTY_GROUP_ELEMENT)) {
            String val = this.tagText.toString();
            this.curGroup.setDescription(val);
        } else {
            super.handleDescriptionEnd();
        }
    }

    protected void handleStepTypeEnd() throws SAXException {
        if (this.hasRoles && !this.hasType) {
            throw new SAXException("step-type cannot have a roles without a type");
        }
        UDCommandExtension ext = (UDCommandExtension)this.curCommand.getExtension();
        if (ext == null && (this.subTag != null || this.curRoleNames != null)) {
            ext = new UDCommandExtension(null, null);
            this.curCommand.setExtension((Extension)ext);
        }
        if (this.subTag != null) {
            ext.setSubTag(this.subTag);
        }
        if (this.curRoleNames != null) {
            for (String roleName : this.curRoleNames) {
                ext.addRoleName(roleName);
            }
        }
        this.hasRoles = false;
        this.hasType = false;
        this.curRoleNames = null;
        this.subTag = null;
        this.hasSubTag = false;
        super.handleStepTypeEnd();
    }

    protected void handlePluginTypeStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("header", PLUGIN_TYPE_ELEMENT);
    }

    protected void handlePluginTypeEnd() throws SAXException {
        String val = this.tagText.toString().trim();
        try {
            this.pluginType = PluginType.valueOf((String)val);
        }
        catch (Exception e) {
            throw new SAXException(val + " is not a valid plugin type");
        }
    }
}

