/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class LoggingX509TrustManager
implements X509TrustManager {
    private static final Logger defaultLog = Logger.getLogger(LoggingX509TrustManager.class);
    private final X509TrustManager delegate;
    private final String delegateName;
    private final Logger log;

    public static TrustManager[] wrap(TrustManager[] managers) {
        return LoggingX509TrustManager.wrap(managers, defaultLog);
    }

    public static TrustManager[] wrap(TrustManager[] managers, Logger log) {
        if (managers != null) {
            for (int i = 0; i < managers.length; ++i) {
                TrustManager manager = managers[i];
                if (!(manager instanceof X509TrustManager)) continue;
                X509TrustManager x509Manager = (X509TrustManager)manager;
                x509Manager = new LoggingX509TrustManager(x509Manager, log);
                managers[i] = x509Manager;
            }
        }
        return managers;
    }

    public LoggingX509TrustManager(X509TrustManager delegate) {
        this(delegate, defaultLog);
    }

    public LoggingX509TrustManager(X509TrustManager delegate, Logger log) {
        this.delegate = Check.nonNull(delegate, "delegate");
        this.log = Check.nonNull(log, "log");
        this.delegateName = delegate.getClass().getName();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.delegateName + ".checkClientTrusted(" + this.extractNames(chain) + ", " + authType + ")");
        }
        try {
            this.delegate.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.delegateName + ".checkClientTrusted() rejected certificate chain", e);
            }
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.delegateName + ".checkServerTrusted(" + this.extractNames(chain) + ", " + authType + ")");
        }
        try {
            this.delegate.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.delegateName + ".checkServerTrusted() rejected certificate chain", e);
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = this.delegate.getAcceptedIssuers();
        if (this.log.isDebugEnabled()) {
            if (issuers == null) {
                this.log.debug(this.delegateName + ".getAcceptedIssuers() = null");
            } else {
                this.log.debug(this.delegateName + ".getAcceptedIssuers() = " + this.extractNames(issuers));
            }
        }
        return issuers;
    }

    private List<String> extractNames(X509Certificate[] certs) {
        ArrayList<String> result = new ArrayList<String>();
        for (X509Certificate cert : certs) {
            String certName = "null";
            if (cert != null) {
                String name;
                String subjectDnName = "<unknown>";
                Principal subjectDN = cert.getSubjectDN();
                if (subjectDN != null && (name = subjectDN.getName()) != null) {
                    subjectDnName = name;
                }
                certName = subjectDnName;
            }
            result.add(certName);
        }
        return result;
    }
}

