/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class EachFileAndDirectoryPPIterator
extends AbstractSentinelIterator<File> {
    private final Iterator<File> iterator;
    private final Pattern filePattern;
    private final Pattern directoryPattern;

    EachFileAndDirectoryPPIterator(File directory, Pattern filePattern, Pattern directoryPattern) {
        this.iterator = IO.listFiles(directory).iterator();
        this.filePattern = filePattern;
        this.directoryPattern = directoryPattern;
    }

    @Override
    protected File nextItem() {
        File result = null;
        while (this.iterator.hasNext()) {
            File file = this.iterator.next();
            String name = file.getName();
            if (file.isFile() && this.filePattern.matcher(name).matches()) {
                result = file;
                break;
            }
            if (!file.isDirectory() || !this.directoryPattern.matcher(name).matches()) continue;
            result = file;
            break;
        }
        return result;
    }
}

