/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.externalsort;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.externalsort.RecordBuffer;
import com.urbancode.commons.util.externalsort.RecordIOFactory;
import com.urbancode.commons.util.externalsort.RecordReader;
import com.urbancode.commons.util.externalsort.RecordWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
class Partition<T> {
    private static final Logger log = Logger.getLogger(Partition.class);
    private final int maxRecordsInMemory;
    private final RecordIOFactory<T> factory;
    private final Comparator<? super T> comparator;
    private final ArrayList<File> files;

    Partition(int maxRecordsInMemory, RecordIOFactory<T> factory, Comparator<? super T> comparator, ArrayList<File> files) {
        Check.nonNull(files, "files");
        if (files.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (maxRecordsInMemory < files.size()) {
            throw new IllegalArgumentException();
        }
        this.maxRecordsInMemory = maxRecordsInMemory;
        this.factory = Check.nonNull(factory, "factory");
        this.comparator = Check.nonNull(comparator, "comparator");
        this.files = files;
    }

    public void deleteFiles() {
        if (log.isDebugEnabled()) {
            log.debug("Removing intermediate files");
        }
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File file = i.next();
            file.delete();
            i.remove();
        }
    }

    public void mergeToAndSync(File outputFile) throws IOException {
        if (this.files.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Moving one file to " + outputFile);
            }
            IO.move(this.files.get(0), outputFile);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Merging (and syncing) " + this.files.size() + " files to " + outputFile);
            }
            this.mergeTo(IO.openOutputSync(outputFile));
        }
    }

    public void mergeTo(File outputFile) throws IOException {
        if (this.files.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Moving one file to " + outputFile);
            }
            IO.move(this.files.get(0), outputFile);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Merging " + this.files.size() + " files to " + outputFile);
            }
            this.mergeTo(IO.openOutput(outputFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTo(OutputStream output) throws IOException {
        RecordWriter<T> writer = this.factory.newWriter(output);
        try {
            ArrayList<RecordBuffer<T>> buffers = new ArrayList<RecordBuffer<T>>();
            try {
                for (File file : this.files) {
                    RecordReader<T> reader = this.factory.newReader(IO.openInput(file));
                    RecordBuffer<T> buffer = new RecordBuffer<T>(1, reader);
                    buffers.add(buffer);
                }
                for (int i = 0; i < buffers.size(); ++i) {
                    RecordBuffer<T> buffer = (RecordBuffer<T>)buffers.get(i);
                    if (buffer.moveNext()) continue;
                    buffers.remove(i);
                    buffer.close();
                }
                this.redistributeBufferSpace(buffers);
                while (!buffers.isEmpty()) {
                    int min = this.min(buffers);
                    RecordBuffer<T> minBuffer = buffers.get(min);
                    writer.write(minBuffer.current());
                    if (minBuffer.moveNext()) continue;
                    buffers.remove(min);
                    minBuffer.close();
                    this.redistributeBufferSpace(buffers);
                }
            }
            catch (Throwable throwable) {
                for (RecordBuffer recordBuffer : buffers) {
                    if (recordBuffer == null) continue;
                    IO.close(recordBuffer);
                }
                throw throwable;
            }
            for (RecordBuffer<T> buffer : buffers) {
                if (buffer == null) continue;
                IO.close(buffer);
            }
        }
        finally {
            writer.close();
        }
    }

    private void redistributeBufferSpace(ArrayList<RecordBuffer<T>> buffers) {
        for (RecordBuffer<T> buffer : buffers) {
            buffer.setMaxRecords(Math.max(1, this.maxRecordsInMemory / buffers.size()));
        }
    }

    private int min(ArrayList<RecordBuffer<T>> buffers) {
        int min = 0;
        T minItem = buffers.get(0).current();
        for (int i = 1; i < buffers.size(); ++i) {
            T item = buffers.get(i).current();
            if (this.comparator.compare(item, minItem) >= 0) continue;
            min = i;
            minItem = item;
        }
        return min;
    }
}

