import org.apache.commons.httpclient.*
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.auth.AuthScope;
import com.urbancode.anthill3.AHPTool;
import com.urbancode.anthill3.plugin.rtcworkitems.RTCWorkItemHelper;
import com.urbancode.anthill3.XTrustProvider;




def final createItem(String newItemString, createUrl, HttpClient client) {
    HttpMethod createMethod = null;
    try {
        createMethod = new PostMethod(createUrl);
		createMethod.setRequestEntity((RequestEntity)new StringRequestEntity(newItemString));
		createMethod.setRequestHeader("Accept", "application/x-oslc-cm-change-request+xml");
    	createMethod.setRequestHeader("Content-type", "application/x-oslc-cm-change-request+xml");
        result = client.executeMethod(createMethod);
        def resp = createMethod.getResponseBodyAsString();
        if (result <300 && result >=200) {
        	return result;
        }
        else {
        	println newItemString
        	println resp;
        	return result;
        }
    }
    finally {
        if (createMethod != null) {
            createMethod.releaseConnection();
        }
    }
}





def ahpTool = new AHPTool();
def props = ahpTool.getStepProperties();

def username = props['integration/username'];
def password= props['integration/password'];
def projectName = props['projectName'];
def base_url = props['integration/url'];
def defectName = props['defectName'];
def description = props['description'];
def type=props['type'];
def severity=props['severity'];
def priority=props['priority'];
def state = props['state'];
def submitter=props['submitter'];
def build=props['build'];

def host = new URL(base_url).getHost();
def port = new URL(base_url).getPort();


HttpClient client= new HttpClient();


XTrustProvider.install();
def rtcHelper = new RTCWorkItemHelper(props);
catalogurl = rtcHelper.getCatalogUrl(client);
rtcHelper.authenticateRTCUser(catalogurl, client);
rtcHelper.authenticateRTCUser(catalogurl, client);
servicesUrl = rtcHelper.getServicesUrl(catalogurl, client);
workItemUrl = rtcHelper.getWorkItemUrl(servicesUrl, client);
creationUrl = rtcHelper.getCreationUrl(servicesUrl, client);

def builder = new groovy.xml.StreamingMarkupBuilder()
builder.encoding = "UTF-8"
def newItem = {
  mkp.xmlDeclaration()
  mkp.declareNamespace('oslc_cm':'http://open-services.net/xmlns/cm/1.0/')
  mkp.declareNamespace('rtc_cm':'http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/')
  mkp.declareNamespace('dc': 'http://purl.org/dc/terms/')
  oslc_cm.ChangeRequest{
    dc.description(description)
    dc.title(defectName)
    dc.type(type)
  }
}
String newItemStr = builder.bind(newItem)

def createResult = createItem(newItemStr, creationUrl, client);
if (createResult < 300 && createResult >= 200) {
	println("Successfully created work item.");
	System.exit(0);
} else {
	println("Failed to create work item. Result was ${createResult}");
	System.exit(1);
}

