package com.urbancode.anthill3.plugin.integration

import org.apache.commons.httpclient.*
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.*

import com.urbancode.anthill3.AHPTool;
import com.urbancode.anthill3.plugin.rtcworkitems.RTCWorkItemHelper;
import com.urbancode.anthill3.XTrustProvider;


public class PublishDefectReport extends IntegrationBase {
    
    //*****************************************************************************************************************
     // CLASS
     //*****************************************************************************************************************
     
     //*****************************************************************************************************************
     // INSTANCE
     //*****************************************************************************************************************
     
     String workItemProperty = 'rtc.workitems'
     String projectName
     java.util.regex.Pattern defectPattern
     
     def etag
     
     def ahpTool = new AHPTool();
     def props = ahpTool.getStepProperties();
     final def ahptool = ahpTool.isWindows ? 'ahptool.cmd' : 'ahptool'
     
     public void execute() {
         HttpClient client= new HttpClient();
         
         XTrustProvider.install();
         def rtcHelper = new RTCWorkItemHelper(props);
         def catalogurl = rtcHelper.getCatalogUrl(client);
         rtcHelper.authenticateRTCUser(catalogurl, client);
         def servicesUrl = rtcHelper.getServicesUrl(catalogurl, client);
         def workItemUrl = rtcHelper.getWorkItemUrl(servicesUrl, client);
         
         try {
             def sourceChangesProc = [ahptool, "getSourceChanges"].execute()
             sourceChangesProc.consumeProcessErrorStream(System.out);
             def changesXml = sourceChangesProc.text
             sourceChangesProc.waitFor()
             if (sourceChangesProc.exitValue()) {
                 throw new Exception("Failed to get build life source changes from ahptool: $changesXml")
             }
             System.out.println "Parsing source changes for work items..."
             def defectIdSet = [] as Set
             def defectIdToChangeSetListMap = [:]
             new XmlSlurper().parseText(changesXml)."change-set".each { changeSetElem ->
                 if (changeSetElem.'properties'.size() > 0) {
                     changeSetElem.'properties'.'property'.each {
                         if (workItemProperty.equalsIgnoreCase(it.'name'.text())) {
                             it.'value'.text().split(',').each { item ->
                                 if (item.matches(defectPattern)) {
                                     defectIdSet << item
                                 }
                             }
                         }
                     }
                 
                     defectIdSet.each { item ->
                         def currentIDSet = defectIdToChangeSetListMap[item] ?: [] as Set
                         currentIDSet << changeSetElem.'anthill-id'.text() ?: changeSetElem.'id'.text()
                         defectIdToChangeSetListMap.put(item, currentIDSet)
                     }
                 }
             }
             if (defectIdSet.size() == 0) {
                 println "No RTC work items were found in the source changes.";
             }
             else {
                 println "${defectIdSet.size()} RTC work items were found in the source changes.";
                 println("Creating Issus.xml.")
                 def issuesXml = new java.io.StringWriter()
                 new groovy.xml.MarkupBuilder(issuesXml).issues() {
                     for (def defectId in defectIdSet) {
                         println "Adding $defectId to Issues.xml."
                         def defectData = getWorkItemByIdentifier(defectId, workItemUrl, client);
                         def defectXml = new XmlParser().parseText(defectData);
                         if (defectXml.attributes()[RTCWorkItemHelper.n_oslc_cm.'totalCount'].equals("1")) {
                             println "Found RTC work item $defectId";
                             
                             //create issue element
                             String changeId = defectIdToChangeSetListMap.get(defectId).join(' ');
                             issue(id:defectId, "issue-tracker":"RTC", "change-id":changeId) {
                                 name(defectXml[RTCWorkItemHelper.n_oslc_cm.ChangeRequest][RTCWorkItemHelper.n_dc.title].text())
                                 def descrip = defectXml[RTCWorkItemHelper.n_oslc_cm.ChangeRequest][RTCWorkItemHelper.n_dc.description].text();
                                 description(descrip)
                                 def statusURL = defectXml[RTCWorkItemHelper.n_oslc_cm.ChangeRequest][RTCWorkItemHelper.n_rtc_cm.state][0].attributes()[RTCWorkItemHelper.n_rdf.'resource'];
                                 def statusXML=getURL(statusURL, client);
                                 def statusInfo = new XmlParser().parseText(statusXML);
                                 def typeURL = defectXml[RTCWorkItemHelper.n_oslc_cm.ChangeRequest][RTCWorkItemHelper.n_dc.type][0].attributes()[RTCWorkItemHelper.n_rdf.'resource'];
                                 def typeXML=getURL(typeURL, client);
                                 def typeInfo = new XmlParser().parseText(typeXML);
                                 def reportStatus = statusInfo[RTCWorkItemHelper.n_dc.title][0].text()
                                 def reportType = typeInfo[RTCWorkItemHelper.n_dc.title][0].text()
                                 status(reportStatus);
                                 type(reportType);
                                 String workitemUrl = url;
                                if (!workItemUrl.endsWith('/')) {
                                    workitemUrl += '/'
                                }
                                workitemUrl += "web/projects/" + projectName + "#action=com.ibm.team.workitem.viewWorkItem&id=" + defectId;
                                url(workitemUrl);
                             }
                         }
                         else {
                             println "Unable to find RTC work item $defectId";
                         }
                     }
                 }
                 println "Uploading Issues.xml.";
                 
                 def addIssuesProc = new ProcessBuilder([ahptool, 'addIssues', '-']).directory(workDir).start()
                 addIssuesProc.consumeProcessOutput(System.out, System.out);
                 addIssuesProc.withWriter{ it << issuesXml }
                 
                 addIssuesProc.waitFor()
                 
                 if (addIssuesProc.exitValue()) {
                     println("RTC results upload to server failed with exit code: ${addIssuesProc.exitValue()}")
                     System.exit(addIssuesProc.exitValue())
                 }
                 else {
                     println()
                     println("RTC results uploaded successfully.")
                 }
             }
         }
         catch (Exception e) {
             e.printStackTrace()
             System.exit(1)
         }
         
     }
     
     def final String getWorkItemByIdentifier(String identifier, String queryUrl, HttpClient client) {
         HttpMethod queryMethod = null;
         String resp ="";
         try {
             queryMethod = new GetMethod(queryUrl + '.xml?oslc_cm.query=' + URLEncoder.encode('dc:identifier="' + identifier + '"', "UTF-8"));
             queryMethod.setRequestHeader("Accept", "application/x-oslc-cm-change-request+xml");
             def result = client.executeMethod(queryMethod);
             resp = queryMethod.getResponseBodyAsString();
         }
         finally {
             if (queryMethod != null) {
                 queryMethod.releaseConnection();
             }
         }
         return resp;
     }
     
     def final String getURL(String url, HttpClient client) {
         HttpMethod getMethod = null;
         String resp = "";
         try {
             getMethod = new GetMethod(url);
             getMethod.setRequestHeader("Accept", "application/xml");
             def result = client.executeMethod(getMethod);
             resp=getMethod.getResponseBodyAsString();
         }
         finally {
             if (getMethod != null) {
                 getMethod.releaseConnection();
             }
         }
         return resp;
     }
}
