package com.urbancode.anthill3.plugin.integration

import org.apache.commons.httpclient.*
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.*

import com.urbancode.anthill3.AHPTool;
import com.urbancode.anthill3.plugin.rtcworkitems.RTCWorkItemHelper;
import com.urbancode.anthill3.XTrustProvider;


public class AddComment extends IntegrationBase {
    
    //*****************************************************************************************************************
    // CLASS
    //*****************************************************************************************************************
    
    //*****************************************************************************************************************
    // INSTANCE
    //*****************************************************************************************************************
    
    String workItemProperty = 'rtc.workitems'
    String projectName
    java.util.regex.Pattern defectPattern
    boolean chnglgComments
    String comment
    
    def ahpTool = new AHPTool();
    def props = ahpTool.getStepProperties();
    final def ahptool = ahpTool.isWindows ? 'ahptool.cmd' : 'ahptool'
    
    public void execute() {
        addComment();
    }
    
    public void addComment() {
        HttpClient client= new HttpClient();
        
        XTrustProvider.install();
        def rtcHelper = new RTCWorkItemHelper(props);
        def catalogurl = rtcHelper.getCatalogUrl(client);
        rtcHelper.authenticateRTCUser(catalogurl, client);
        def servicesUrl = rtcHelper.getServicesUrl(catalogurl, client);
        def workItemUrl = rtcHelper.getWorkItemUrl(servicesUrl, client);
        
        try {
            def sourceChangesProc = [ahptool, "getSourceChanges"].execute()
            sourceChangesProc.consumeProcessErrorStream(System.out);
            def changesXml = sourceChangesProc.text
            sourceChangesProc.waitFor()
            if (sourceChangesProc.exitValue()) {
                throw new Exception("Failed to get build life source changes from ahptool: $changesXml")
            }
            System.out.println "Examining source changes for work items..."
            def defectIdSet = [] as Set
            def defectIdToChangeSetListMap = [:]
            new XmlSlurper().parseText(changesXml)."change-set".each { changeSetElem ->
                if (changeSetElem.'properties'.size() > 0) {
                     changeSetElem.'properties'.'property'.each {
                         if (workItemProperty.equalsIgnoreCase(it.'name'.text())) {
                             it.'value'.text().split(',').each { item ->
                                 if (item.matches(defectPattern)) {
                                     defectIdSet << item
                                 }
                             }
                         }
                     }
                 
                     defectIdSet.each { item ->
                         def currentCommentSet = defectIdToChangeSetListMap[item] ?: [] as Set
                         currentCommentSet << changeSetElem.'comment'.text() ?: changeSetElem.'id'.text()
                         defectIdToChangeSetListMap.put(item, currentCommentSet)
                     }
                 }
             }
            if (defectIdSet.size() == 0) {
                println "No RTC work items were found in the source changes.";
            }
            else {
                println "${defectIdSet.size()} RTC work items were found in the source changes.";
                for (def defectId in defectIdSet) {
                    def defectData = null
                    HttpMethod method = null
                    def response = null
                    def createResult;
                    defectData = getWorkItemByIdentifier(defectId, workItemUrl, client);
                    if (!defectData) {
                        continue;
                    }
                    def defectXml = new XmlParser().parseText(defectData);
                    if (defectXml.attributes()[RTCWorkItemHelper.n_oslc_cm.'totalCount'].equals("1")) {
                        //lets add the comment
                        def builder = new groovy.xml.StreamingMarkupBuilder()
                        def changeLogText = defectIdToChangeSetListMap.get(defectId)
                        def workItemComment = (chnglgComments ? changeLogText.join(' ') + ' ' : "") + (comment ?: '')
                        println "Adding comment for work item $defectId";
                        builder.encoding = "UTF-8"
                        def newComment = {
                          mkp.xmlDeclaration()
                          mkp.declareNamespace('oslc_cm':'http://open-services.net/xmlns/cm/1.0/')
                          mkp.declareNamespace('rtc_cm':'http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/')
                          mkp.declareNamespace('dc': 'http://purl.org/dc/terms/')
                          rtc_cm.Comment{
                            dc.description(workItemComment);
                          }
                        }
                        //get the post url
                        def commentUrl =
                            defectXml[RTCWorkItemHelper.n_oslc_cm.ChangeRequest][RTCWorkItemHelper.n_rtc_cm.comments][0]
                                     .attributes()[RTCWorkItemHelper.n_oslc_cm.'collref'];
                        //post the new comment
                        try {
                            method = new PostMethod(commentUrl);
                            String newCommentString = builder.bind(newComment);
                            method.setRequestEntity((RequestEntity)new StringRequestEntity(newCommentString));
                            method.setRequestHeader("Accept", "application/x-oslc-cm-change-request+xml");
                            method.setRequestHeader("Content-type", "application/x-oslc-cm-change-request+xml");
                            createResult = client.executeMethod(method);
                            if (createResult < 300 && createResult >= 200) {
                                println "Successfully added comment to work item $defectId";
                            }
                            else {
                                println "Failed to add comment to work item $defectId";
                                println method.getResponseBodyAsString();
                                System.exit(1);
                            }
                        }
                        finally {
                            if (method != null) {
                                method.releaseConnection();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace()
            System.exit(1)
        }
    }
    
    def final String getWorkItemByIdentifier(String identifier, String queryUrl, HttpClient client) {
        HttpMethod queryMethod = null;
        String resp = "";
        try {
            queryMethod = new GetMethod(queryUrl + '.xml?oslc_cm.query=' + URLEncoder.encode('dc:identifier="' + identifier + '"', "UTF-8"));
            queryMethod.setRequestHeader("Accept", "application/x-oslc-cm-change-request+xml");
            def result = client.executeMethod(queryMethod);
            resp = queryMethod.getResponseBodyAsString();
        }
        finally {
            if (queryMethod != null) {
                queryMethod.releaseConnection();
            }
        }
        return resp;
    }
}
