package com.urbancode.anthill3;

import groovy.util.slurpersupport.GPathResult;

public class StepInfo {
    
    //******************************************************************************************************************
    // CLASS
    //******************************************************************************************************************
    
    //******************************************************************************************************************
    // INSTANCE
    //******************************************************************************************************************
    private GPathResult data;
    
    //------------------------------------------------------------------------------------------------------------------
    public StepInfo(GPathResult data) {
        this.data = data;
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getProjectName() {
        return data.project.name.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getProjectId() {
        return Long.valueOf(data.project.@dbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getOriginatingWorkflowName() {
        return data.originatingWorkflow.name.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getOriginatingWorkflowId() {
        return Long.valueOf(data.originatingWorkflow.@dbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getOriginatingWorkflowCaseId() {
        return Long.valueOf(data.originatingWorkflow.@caseDbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getRequestId() {
        return Long.valueOf(data.request.@dbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getRequestUser() {
        return data.request.user.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getCurrentWorkflowName() {
        return data.currentWorkflow.name.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getCurrentWorkflowId() {
        return Long.valueOf(data.currentWorkflow.@dbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getCurrentWorkflowCaseId() {
        return Long.valueOf(data.currentWorkflow.@caseDbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getJobName() {
        return data.job.name.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Long getJobId() {
        return Long.valueOf(data.job.@dbId.text());
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public String getStepName() {
        return data.step.name.text();
    }
    
    //------------------------------------------------------------------------------------------------------------------
    public Integer getStepIndex() {
        return Integer.valueOf(data.step.@dbId.text());
    }
}