/*
 * Licensed Materials - Property of IBM
 * 5725-I43 (C) Copyright IBM Corp. 2006, 2013. All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
 
#import <Foundation/Foundation.h>

/**
 * @ingroup main
 * WLTrusteer allows access to risk assessment generated by Trusteer.
 * This requires the Trusteer Mobile SDK to be installed separately.
 */
@interface WLTrusteer : NSObject
/**
 * Provides a WLTrusteer singleton
 * @returns The shared WLTrusteer object
 */
+(id)sharedInstance;

/**
 * Checks that the Trusteer SDK is succesfully loaded
 *  @returns true if Trusteer is available
 */
-(BOOL)hasTrusteerSDK;

/**
 * Get a unique device identifier generated by Trusteer
 * @returns The Trusteer device key
 */
-(NSString*)deviceKey;

/**
 * Generate a NSDictionary with all the risk assessments generated by Trusteer. 
 * See Trusteer documentation for a list of value.
 * @returns Risk assessments dictionary
 */
-(NSDictionary*)riskAssessment;

/**
 * Generate a JSON string with all the risk assessments generated by Trusteer.
 * See Trusteer documentation for a list of value.
 * @returns Risk assessments JSON String
 */
-(NSString*)riskAssessmentAsJson;
@end
