/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.webkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.javascript.JavaScriptInterface;
import com.tl.uic.webkit.UICWebChromeClient;
import com.tl.uic.webkit.UICWebViewClient;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICWebView
extends WebView {
    private Date endLoad;
    private Date startLoad;
    private String url;
    private HttpResponse httpResponse;
    private Date initTime;
    private long responseTime;
    private long connectionInitFromSession;

    public UICWebView(Context context) {
        super(context);
        this.init();
    }

    public UICWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public UICWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public final Date getEndLoad() {
        return this.endLoad;
    }

    public final void setEndLoad(Date endLoad) {
        this.endLoad = endLoad;
    }

    public final Date getStartLoad() {
        return this.startLoad;
    }

    public final void setStartLoad(Date startLoad) {
        this.startLoad = startLoad;
    }

    public final HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public final void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public final Date getInitTime() {
        return this.initTime;
    }

    public final void setInitTime(Date initTime) {
        this.initTime = initTime;
        this.connectionInitFromSession = TLFCache.timestampFromSession();
    }

    public final long getResponseTime() {
        return this.responseTime;
    }

    public final void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.url = null;
        this.initTime = null;
        this.connectionInitFromSession = 0L;
        this.responseTime = 0L;
        this.httpResponse = null;
        this.startLoad = new Date();
        super.loadDataWithBaseURL(this.url, data, mimeType, encoding, "");
    }

    @SuppressLint(value={"NewApi"})
    public void loadUrl(String url) {
        this.loadUrl(url, null);
    }

    public final void loadUrl(String url, Map<String, String> extraHeaders) {
        this.url = url;
        Tealeaf.setTLCookie(this.url);
        super.loadUrl(url, extraHeaders);
    }

    private void init() {
        this.setStartLoad(new Date());
        this.setWebViewClient(new UICWebViewClient());
        this.setWebChromeClient(new UICWebChromeClient((Activity)this.getContext()));
        this.addJavascriptInterface(new JavaScriptInterface(this.getContext()), "tlBridge");
    }

    public final Boolean logConnection() {
        long endTime = this.getEndLoad() != null ? this.getEndLoad().getTime() : 0L;
        long startTime = this.getStartLoad() != null ? this.getStartLoad().getTime() : 0L;
        long loadTime = endTime - startTime;
        return Tealeaf.logConnection(this.url, this.httpResponse, this.connectionInitFromSession, loadTime, this.responseTime);
    }
}

