/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import com.tl.uic.util.ConfigurationUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValueUtil {
    private static volatile ValueUtil _myInstance;

    private ValueUtil() {
    }

    public static synchronized ValueUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new ValueUtil();
        }
        return _myInstance;
    }

    public static String trimValue(String value) {
        if (value == null) {
            return value;
        }
        int maxLength = ConfigurationUtil.getInt("MaxStringsLength");
        StringBuffer stringBuffer = new StringBuffer(maxLength);
        if (value.length() > maxLength) {
            stringBuffer.append(value, 0, maxLength);
        } else {
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    public static String maskValue(String originalValue) {
        String value = originalValue;
        Boolean hasMasking = ConfigurationUtil.getBoolean("HasMasking");
        Boolean hasCustomMasking = ConfigurationUtil.getBoolean("HasCustomMask");
        String smallCase = ConfigurationUtil.getString("SensitiveSmallCaseAlphabet");
        String capitalCase = ConfigurationUtil.getString("SensitiveCapitalCaseAlphabet");
        String symbol = ConfigurationUtil.getString("SensitiveSymbol");
        String number = ConfigurationUtil.getString("SensitiveNumber");
        if (hasMasking.booleanValue()) {
            if (hasCustomMasking.booleanValue()) {
                value = value.replaceAll("\\p{Ll}", smallCase);
                value = value.replaceAll("\\p{Lu}", capitalCase);
                value = value.replaceAll("\\p{P}|\\p{S}", symbol);
                value = value.replaceAll("\\p{N}", number);
            } else {
                return "";
            }
        }
        return value;
    }

    public static String compareListAndMask(String id, String value) {
        String[] keys;
        if (id == null || value == null) {
            return value;
        }
        String[] stringArray = keys = ConfigurationUtil.getString("MaskIdList").split(",");
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(id);
            if (matcher.find()) {
                return ValueUtil.maskValue(value);
            }
            ++n2;
        }
        return value;
    }
}

