/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.tl.uic.app.UICActivity;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.LogScreenTask;
import com.tl.uic.util.ScreenShotTask;
import com.tl.uic.webkit.UICWebView;

@SuppressLint(value={"NewApi"})
public class UICOnGlobalLayoutListener
implements ViewTreeObserver.OnGlobalLayoutListener {
    private View view;
    private Activity activity;
    private int numOnGlobalLayoutListener;
    private String logicalPageName;
    private int delayMS;
    private Boolean takeLogScreenLayout;
    private String currentLayoutKey;

    public UICOnGlobalLayoutListener(Activity activity, View view, String logicalPageName) {
        this.init(activity, view, logicalPageName, 1, true, null);
    }

    public UICOnGlobalLayoutListener(Activity activity, View view, String logicalPageName, int delayMS) {
        this.init(activity, view, logicalPageName, delayMS, true, null);
    }

    public UICOnGlobalLayoutListener(Activity activity, View view, String logicalPageName, int delayMS, Boolean takeLogScreenLayout) {
        this.init(activity, view, logicalPageName, delayMS, takeLogScreenLayout, null);
    }

    public UICOnGlobalLayoutListener(Activity activity, View view, String logicalPageName, int delayMS, Boolean takeLogScreenLayout, String currentLayoutKey) {
        this.init(activity, view, logicalPageName, delayMS, takeLogScreenLayout, currentLayoutKey);
    }

    private void init(Activity activity, View view, String logicalPageName, int delayMS, Boolean takeLogScreenLayout, String currentLayoutKey) {
        this.numOnGlobalLayoutListener = 1;
        this.activity = activity;
        this.view = view;
        this.logicalPageName = logicalPageName;
        this.delayMS = delayMS;
        this.takeLogScreenLayout = takeLogScreenLayout;
        this.currentLayoutKey = currentLayoutKey;
    }

    public final void onGlobalLayout() {
        if (this.view instanceof ViewGroup) {
            int i = 0;
            while (i < ((ViewGroup)this.view).getChildCount()) {
                View child = ((ViewGroup)this.view).getChildAt(i);
                this.setListenersOnChildren(child);
                ++i;
            }
        }
        if (Build.VERSION.SDK_INT > 15) {
            this.view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        --this.numOnGlobalLayoutListener;
        if (!(this.view instanceof UICWebView) && (this.activity instanceof UICActivity && ((UICActivity)this.activity).getTakeSnapshotAfterCreate().booleanValue() || ConfigurationUtil.getBoolean("LogViewLayoutOnScreenTransition").booleanValue()) && (!(this.activity instanceof UICActivity) || !((UICActivity)this.activity).getTookImage().booleanValue()) && this.numOnGlobalLayoutListener == 0) {
            final String currentLogicalPageName = this.logicalPageName;
            Thread thread = new Thread(){

                public void run() {
                    UICOnGlobalLayoutListener.this.activity.runOnUiThread(new Runnable(){

                        public void run() {
                            if (UICOnGlobalLayoutListener.this.activity instanceof UICActivity && ((UICActivity)UICOnGlobalLayoutListener.this.activity).getTakeSnapshotAfterCreate().booleanValue()) {
                                ScreenShotTask screenShotTask = new ScreenShotTask(UICOnGlobalLayoutListener.this.view);
                                screenShotTask.execute(new Void[0]);
                                ((UICActivity)UICOnGlobalLayoutListener.this.activity).setTookImage(true);
                            }
                            if (UICOnGlobalLayoutListener.this.takeLogScreenLayout.booleanValue() && ConfigurationUtil.getBoolean("LogViewLayoutOnScreenTransition").booleanValue()) {
                                LogScreenTask logScreenTask = new LogScreenTask(UICOnGlobalLayoutListener.this.activity, currentLogicalPageName, UICOnGlobalLayoutListener.this.delayMS, UICOnGlobalLayoutListener.this.currentLayoutKey);
                                logScreenTask.execute(new Void[0]);
                            }
                        }
                    });
                }
            };
            thread.start();
        }
    }

    public final void setListenersOnChildren(View viewChild) {
        if (viewChild instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewChild;
            int i = 0;
            while (i < viewGroup.getChildCount()) {
                View child = viewGroup.getChildAt(i);
                if (!(child instanceof ListView || child instanceof ImageView || child instanceof LinearLayout || child instanceof TextView || child.getHeight() != 0 && child.getWidth() != 0)) {
                    child.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new UICOnGlobalLayoutListener(this.activity, child, this.logicalPageName, this.delayMS, this.takeLogScreenLayout, this.currentLayoutKey));
                    ++this.numOnGlobalLayoutListener;
                }
                ++i;
            }
        }
    }
}

