/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.util.LogInternal;
import java.math.BigDecimal;

public class ScreenReceiver
extends BroadcastReceiver {
    private int rotation = 0;
    private int height;
    private float deviceHeight;
    private int width;
    private float deviceWidth;
    private float pixelDensity;
    private static final int ROTATION_O = 0;
    private static final int ROTATION_9O = 90;
    private static final int ROTATION_18O = 180;
    private static final int ROTATION_NEGATIVE_9O = -90;

    public final int getRotation() {
        return this.rotation;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float getDeviceHeight() {
        return this.deviceHeight;
    }

    public final int getWidth() {
        return this.width;
    }

    public final float getDeviceWidth() {
        return this.deviceWidth;
    }

    public final float getPixelDensity() {
        return this.pixelDensity;
    }

    public ScreenReceiver() {
        this.screenUpdate();
    }

    @SuppressLint(value={"NewApi"})
    private Display screenUpdate() {
        Display display = ((WindowManager)Tealeaf.getApplication().getApplicationContext().getSystemService("window")).getDefaultDisplay();
        if (Build.VERSION.SDK_INT > 12) {
            Point size = new Point();
            display.getSize(size);
            this.width = size.x;
            this.height = size.y;
        } else {
            this.width = display.getWidth();
            this.height = display.getHeight();
        }
        this.pixelDensity = Tealeaf.getApplication().getResources().getDisplayMetrics().density;
        this.deviceHeight = ScreenReceiver.round(this.pixelDensity == 0.0f ? (float)this.height : (float)this.height / this.pixelDensity);
        this.deviceWidth = ScreenReceiver.round(this.pixelDensity == 0.0f ? (float)this.width : (float)this.width / this.pixelDensity);
        LogInternal.log("Screen height:" + this.height + "  width:" + this.width + " Pixel density:" + this.pixelDensity + " Device height:" + this.deviceHeight + " width:" + this.deviceWidth);
        return display;
    }

    public final void onReceive(Context context, Intent intent) {
        if ("android.intent.action.CONFIGURATION_CHANGED".equalsIgnoreCase(intent.getAction())) {
            Display display = this.screenUpdate();
            this.rotation = Build.VERSION.SDK_INT > 7 ? ScreenReceiver.getRotation(display.getRotation()) : ScreenReceiver.getRotation(display.getOrientation());
            LogInternal.log("Screen change:" + this.rotation);
            if (TLFCache.getEnvironmentalData() != null) {
                TLFCache.getEnvironmentalData().hasClientStateChanged();
            }
        }
    }

    public static int getRotation(int orientation) {
        int rotation = 0;
        switch (orientation) {
            case 0: {
                rotation = 0;
                break;
            }
            case 1: {
                rotation = 90;
                break;
            }
            case 2: {
                rotation = 180;
                break;
            }
            case 3: {
                rotation = -90;
            }
        }
        return rotation;
    }

    public static float round(float value) {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(value));
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.floatValue();
    }
}

