/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.os.AsyncTask;
import com.tl.uic.TLFCache;
import com.tl.uic.model.MessageFormat;
import com.tl.uic.model.TLFCacheFile;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.FileUtil;
import com.tl.uic.util.GCUtil;
import com.tl.uic.util.HTTPUtil;
import com.tl.uic.util.LogInternal;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostTask
extends AsyncTask<Void, Void, Boolean> {
    private static final int BUFFER_SIZE = 40;
    private Boolean _isRunning = false;

    protected final Boolean doInBackground(Void ... args) {
        Boolean result = false;
        try {
            this._isRunning = true;
            result = this.sendMessageFormat();
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return result;
    }

    private Boolean sendMessageFormat() {
        Boolean result = false;
        if (TLFCache.getEnvironmentalData() != null && TLFCache.getEnvironmentalData().getConnectionReceiver() != null && !TLFCache.getEnvironmentalData().getConnectionReceiver().isOnline().booleanValue() && TLFCache.getMessages() == null && TLFCache.getMessages().size() > 0) {
            return result;
        }
        Boolean isGZipped = ConfigurationUtil.getBoolean("CompressPostMessage");
        String url = ConfigurationUtil.getString("PostMessageUrl");
        List<TLFCacheFile> messageFormats = TLFCache.messageFormats();
        if (messageFormats != null && !messageFormats.isEmpty()) {
            Date currentDate = new Date();
            for (TLFCacheFile tlfCacheFile : messageFormats) {
                if (tlfCacheFile.isImage().booleanValue()) {
                    result = tlfCacheFile.getDirectory() == null ? HTTPUtil.sendHttpImagePost(url, tlfCacheFile.getSessionId(), tlfCacheFile.getFileName(), (ByteArrayOutputStream)tlfCacheFile.getData()) : HTTPUtil.sendHttpImagePost(url, tlfCacheFile.getSessionId(), tlfCacheFile.getDirectory(), tlfCacheFile.getFileName());
                    if (result.booleanValue()) {
                        this.logResult(tlfCacheFile.getSessionId(), tlfCacheFile.getFileName(), true);
                        if (tlfCacheFile.getDirectory() != null) {
                            FileUtil.deleteFile(tlfCacheFile.getDirectory(), tlfCacheFile.getFileName());
                        }
                    }
                } else if ((String)tlfCacheFile.getData() != null) {
                    result = HTTPUtil.sendHttpPost(url, tlfCacheFile.getSessionId(), (String)tlfCacheFile.getData(), isGZipped, tlfCacheFile.getHasUICData());
                    this.logResult(tlfCacheFile.getSessionId(), (String)tlfCacheFile.getData(), false);
                }
                if (result.booleanValue()) continue;
                if (ConfigurationUtil.getBoolean("HasToPersistLocalCache").booleanValue()) {
                    FileUtil.saveObject(tlfCacheFile, "TLFCache", "cache_" + currentDate.getTime());
                    LogInternal.log("Saving to device.");
                } else {
                    TLFCache.addToMemoryFiles(tlfCacheFile);
                    if (tlfCacheFile.getData() instanceof MessageFormat) {
                        LogInternal.log("Save to memory queue:" + ((MessageFormat)tlfCacheFile.getData()).getJSON().toString());
                    }
                }
                LogInternal.log("Could not send message.");
            }
        }
        isGZipped = null;
        url = null;
        GCUtil.clean(messageFormats);
        messageFormats = null;
        return result;
    }

    private void logResult(String sessionId, String secondMessage, Boolean isImage) {
        StringBuffer logMessage = new StringBuffer(40);
        logMessage.append("PostTask with session id:");
        logMessage.append(sessionId);
        LogInternal.log(logMessage.toString());
        if (logMessage.length() >= 1) {
            logMessage.delete(0, logMessage.length());
        }
        if (isImage.booleanValue()) {
            logMessage.append("PostTask image:");
        } else {
            logMessage.append("PostTask JSON:");
        }
        logMessage.append(secondMessage);
        LogInternal.log(logMessage.toString());
        logMessage = null;
    }

    public final Boolean isRunning() {
        return this._isRunning;
    }

    protected final void onPostExecute(Boolean result) {
        this._isRunning = false;
        TLFCache.closePostTask();
    }
}

