/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.app.Activity;
import android.os.AsyncTask;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.Layout;
import com.tl.uic.util.LogInternal;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogScreenTask
extends AsyncTask<Void, Void, Layout> {
    private WeakReference<Activity> activityWeakReference;
    private String name;
    private int delayMS;
    private String currentLayoutKey;

    public LogScreenTask(Activity activity, String name, int delayMS) {
        this.init(activity, name, delayMS, TLFCache.setCurrentLayoutKey());
    }

    public LogScreenTask(Activity activity, String name, int delayMS, String currentLayoutKey) {
        this.init(activity, name, delayMS, currentLayoutKey);
    }

    private void init(Activity activity, String name, int delayMS, String currentLayoutKey) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.name = name;
        this.delayMS = delayMS;
        this.currentLayoutKey = currentLayoutKey != null ? currentLayoutKey : TLFCache.setCurrentLayoutKey();
    }

    protected final Layout doInBackground(Void ... params) {
        Layout result = null;
        try {
            if (this.activityWeakReference != null) {
                Thread.sleep(this.delayMS);
                result = Tealeaf.logLayout((Activity)this.activityWeakReference.get(), this.name, false);
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return result;
    }

    protected final void onPostExecute(Layout result) {
        TLFCache.flushLayout(this.currentLayoutKey, result);
    }
}

