/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.util.Log;
import com.tl.uic.Tealeaf;

public final class LogInternal {
    private static volatile LogInternal _myInstance;
    private static boolean _isDEBUG;
    public static final int ERROR = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARNING = 4;
    public static final int VERBOSE = 5;

    static {
        _isDEBUG = false;
    }

    private LogInternal() {
    }

    public static synchronized LogInternal getInstance() {
        if (_myInstance == null) {
            _myInstance = new LogInternal();
        }
        return _myInstance;
    }

    public static boolean isDEBUG() {
        return _isDEBUG;
    }

    public static void setIsDEBUG(boolean isDEBUG) {
        _isDEBUG = isDEBUG;
    }

    public static void log(String message) {
        LogInternal.log(message, 3);
    }

    public static void logException(Throwable exception) {
        LogInternal.logException(exception, null);
    }

    public static Boolean logException(Throwable exception, String extraMessage) {
        StringBuffer exMessage = new StringBuffer(LogInternal.getTLLibErrorExceptionString(exception, extraMessage));
        LogInternal.log(exMessage.toString(), 1);
        if (Tealeaf.isEnabled().booleanValue()) {
            Tealeaf.logTLLibErrorException(exception, extraMessage);
        }
        return true;
    }

    public static String getExceptionMessage(Throwable exception, String extraMessage) {
        StringBuffer exceptionMessage = new StringBuffer();
        if (extraMessage != null) {
            exceptionMessage.append(extraMessage);
            exceptionMessage.append('\t');
        }
        exceptionMessage.append(exception.getMessage());
        return exceptionMessage.toString();
    }

    public static String getTLLibErrorExceptionMessage(Throwable exception, String extraMessage) {
        StringBuffer exceptionMessage = new StringBuffer(20);
        exceptionMessage.append("TL Library Error: ");
        if (extraMessage != null) {
            exceptionMessage.append(extraMessage);
            exceptionMessage.append('\t');
        }
        exceptionMessage.append(exception.getMessage());
        return exceptionMessage.toString();
    }

    public static String getExceptionString(Throwable exception, String extraMessage) {
        StringBuffer exceptionMessage = new StringBuffer();
        if (extraMessage != null) {
            exceptionMessage.append(extraMessage);
            exceptionMessage.append('\t');
        }
        exceptionMessage.append(exception.getMessage());
        exceptionMessage.append(LogInternal.getStackTrace(exception));
        return exceptionMessage.toString();
    }

    public static String getTLLibErrorExceptionString(Throwable exception, String extraMessage) {
        StringBuffer exceptionMessage = new StringBuffer(20);
        exceptionMessage.append("TL Library Error: ");
        if (extraMessage != null) {
            exceptionMessage.append(extraMessage);
            exceptionMessage.append('\t');
        }
        exceptionMessage.append(exception.getMessage());
        exceptionMessage.append(LogInternal.getStackTrace(exception));
        return exceptionMessage.toString();
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = aThrowable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            stackTrace.append(element.toString());
            stackTrace.append("\n");
            ++n2;
        }
        return stackTrace.toString();
    }

    public static void log(String message, int logType) {
        if (LogInternal.isDEBUG()) {
            if (logType == 2) {
                Log.d((String)"UICAndroid", (String)message);
            } else if (logType == 3) {
                Log.i((String)"UICAndroid", (String)message);
            } else if (logType == 4) {
                Log.w((String)"UICAndroid", (String)message);
            } else if (logType == 5) {
                Log.v((String)"UICAndroid", (String)message);
            }
        }
        if (logType == 1) {
            Log.e((String)"UICAndroid", (String)message);
        }
    }
}

