/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.util.Base64;
import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.LogInternal;
import com.tl.uic.util.ValueUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonUtil {
    private static volatile JsonUtil _myInstance;
    private static String _messageTypes;
    private static Hashtable<Integer, Integer> _messageTypesSet;
    private static String _pattern;
    private static final Pattern pattern;

    static {
        _messageTypesSet = new Hashtable();
        _pattern = "type(\"|'):[\\d]+";
        pattern = Pattern.compile(_pattern);
    }

    private JsonUtil() {
    }

    public static synchronized JsonUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new JsonUtil();
        }
        return _myInstance;
    }

    public static JSONObject getHashValues(HashMap<String, Object> hashMap) {
        JSONObject json = null;
        try {
            if (hashMap == null || hashMap.isEmpty()) {
                return json;
            }
            json = new JSONObject();
            for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                if (entry.getValue() instanceof String) {
                    json.accumulate(entry.getKey(), (Object)ValueUtil.trimValue((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    json.accumulate(entry.getKey(), (Object)((Boolean)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof JSONObject) {
                    json.accumulate(entry.getKey(), (Object)((JSONObject)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof JSONArray) {
                    json.accumulate(entry.getKey(), (Object)((JSONArray)entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof byte[])) continue;
                json.accumulate(entry.getKey(), (Object)Base64.encodeToString((byte[])((byte[])entry.getValue()), (int)0));
            }
        }
        catch (JSONException e) {
            LogInternal.logException(e);
        }
        return json;
    }

    public static JSONObject getStringHashValues(HashMap<String, String> hashMap) {
        JSONObject json = null;
        try {
            if (hashMap == null || hashMap.isEmpty()) {
                return json;
            }
            json = new JSONObject();
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                json.accumulate(entry.getKey(), (Object)ValueUtil.trimValue(entry.getValue()));
            }
        }
        catch (JSONException e) {
            LogInternal.logException(e);
        }
        return json;
    }

    private static Boolean getFilterMessageTypes() {
        return ConfigurationUtil.getBoolean("FilterMessageTypes");
    }

    private static Boolean getAddMessageTypeHeader() {
        return ConfigurationUtil.getBoolean("AddMessageTypeHeader");
    }

    public static Boolean testMessageType(Object message, Boolean fromPost) {
        if (message == null) {
            return false;
        }
        if (JsonUtil.getFilterMessageTypes().booleanValue() && !fromPost.booleanValue() || JsonUtil.getAddMessageTypeHeader().booleanValue() && fromPost.booleanValue()) {
            if (_messageTypes == null || !_messageTypes.equals(ConfigurationUtil.getString("MessageTypes"))) {
                _messageTypes = ConfigurationUtil.getString("MessageTypes");
                _messageTypesSet.clear();
                String[] mtypes = _messageTypes.split(",");
                int i = 0;
                while (i < mtypes.length) {
                    Integer integer = Integer.parseInt(mtypes[i]);
                    _messageTypesSet.put(integer, integer);
                    ++i;
                }
            }
            if (message instanceof ClientMessageHeader && !_messageTypesSet.containsKey(((ClientMessageHeader)message).getMessageType().getValue())) {
                return false;
            }
            if (message instanceof String) {
                Matcher matcher = pattern.matcher((CharSequence)message);
                while (matcher.find()) {
                    String[] type = matcher.group().split(":");
                    if (!_messageTypesSet.containsKey(Integer.parseInt(type[1]))) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

