/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.TLFCacheFile;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.FileUtil;
import com.tl.uic.util.LogInternal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Date;

public final class ImageUtil {
    private static volatile ImageUtil _myInstance;
    private static final int PERCENT = 100;
    private static final int LAST_8_BITS = 255;
    private static final int MASK_BITS = 256;
    private static final int THIRD_ELEMENT = 3;

    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageUtil getInstance() {
        if (_myInstance != null) return _myInstance;
        Class<ImageUtil> clazz = ImageUtil.class;
        synchronized (ImageUtil.class) {
            ImageUtil imageUtil;
            _myInstance = imageUtil = new ImageUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _myInstance;
        }
    }

    public static String getImageType() {
        if ("PNG".equalsIgnoreCase(ConfigurationUtil.getString("ScreenshotFormat"))) {
            return "png";
        }
        return "jpg";
    }

    public static Integer getPercentOfScreenshotsSize() {
        return ConfigurationUtil.getInt("PercentOfScreenshotsSize");
    }

    public static Integer getPercentToCompressImage() {
        return ConfigurationUtil.getInt("PercentToCompressImage");
    }

    public static Boolean snapShot(View view, String directory, String imageFileName) {
        if (Tealeaf.isEnabled().booleanValue() && Tealeaf.getApplication() != null && Tealeaf.getApplication().getApplicationContext() != null) {
            return ImageUtil.snapShotHelper(Tealeaf.getApplication().getApplicationContext(), view, directory, new StringBuffer(imageFileName));
        }
        return false;
    }

    private static Boolean snapShotHelper(Context context, View view, String directory, StringBuffer imageFileName) {
        Boolean hasBeenSaved = false;
        try {
            Date currentDate = new Date();
            View mainView = view;
            if (mainView == null) {
                return hasBeenSaved;
            }
            Bitmap result = Bitmap.createBitmap((int)mainView.getWidth(), (int)mainView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (result == null) {
                LogInternal.log("Could not take screenshot, view was garbage collected for " + imageFileName);
                return hasBeenSaved;
            }
            Canvas canvas = new Canvas(result);
            view.setDrawingCacheEnabled(true);
            view.draw(canvas);
            view.setDrawingCacheEnabled(false);
            imageFileName.append("_" + currentDate.getTime() + "." + ImageUtil.getImageType());
            if (TLFCache.getHasToPersistLocalCache().booleanValue()) {
                hasBeenSaved = ImageUtil.saveImage(result, context, directory, imageFileName.toString());
                if (hasBeenSaved.booleanValue()) {
                    TLFCacheFile tlfCacheFile = new TLFCacheFile();
                    tlfCacheFile.setDirectory(directory);
                    tlfCacheFile.setFileName(imageFileName.toString());
                    tlfCacheFile.setSessionId(TLFCache.getCurrentSessionId());
                    tlfCacheFile.isImage(true);
                    TLFCache.saveToCache(false);
                    FileUtil.saveObject(tlfCacheFile, directory, "imageFileName_" + currentDate.getTime());
                }
            } else {
                TLFCacheFile tlfCacheFile = new TLFCacheFile();
                tlfCacheFile.setData(ImageUtil.compressImage(result, imageFileName.toString()));
                tlfCacheFile.setSessionId(TLFCache.getCurrentSessionId());
                tlfCacheFile.setFileName(imageFileName.toString());
                tlfCacheFile.isImage(true);
                TLFCache.saveToCache(false);
                hasBeenSaved = TLFCache.addToMemoryFiles(tlfCacheFile);
            }
            result.recycle();
            result = null;
            Tealeaf.logCustomEvent("Screenshot Taken for file: " + imageFileName);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return hasBeenSaved;
    }

    private static ByteArrayOutputStream compressImage(Bitmap bmp, String filename) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int height = bmp.getHeight() * ImageUtil.getPercentOfScreenshotsSize() / 100;
            int width = bmp.getWidth() * ImageUtil.getPercentOfScreenshotsSize() / 100;
            Bitmap picture = Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)false);
            byteArrayOutputStream = new ByteArrayOutputStream();
            picture.compress(ImageUtil.getCompressFormat(), ImageUtil.getPercentToCompressImage().intValue(), (OutputStream)byteArrayOutputStream);
            picture.recycle();
            picture = null;
        }
        catch (Exception e) {
            LogInternal.logException(e, "Trying to compress image:" + filename);
        }
        return byteArrayOutputStream;
    }

    public static Boolean saveImage(Bitmap bmp, Context context, String directory, String filename) {
        File dir = null;
        File file = null;
        FileOutputStream fileOutputStream = null;
        Boolean hasBeenSaved = false;
        try {
            try {
                dir = context.getDir(directory, 0);
                file = new File(dir, filename);
                fileOutputStream = new FileOutputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = ImageUtil.compressImage(bmp, filename);
                byteArrayOutputStream.writeTo(fileOutputStream);
                LogInternal.log("Saved image to cache:" + file.getAbsolutePath());
                hasBeenSaved = true;
            }
            catch (Exception e) {
                LogInternal.logException(e, "Trying to save file to cache:" + (file == null ? "" : file.getAbsolutePath()));
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (!hasBeenSaved.booleanValue()) {
                        file.delete();
                    }
                }
                catch (Exception e2) {
                    LogInternal.logException(e2);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (!hasBeenSaved.booleanValue()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return hasBeenSaved;
    }

    public static Bitmap.CompressFormat getCompressFormat() {
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
        if ("jpg".equalsIgnoreCase(ImageUtil.getImageType())) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        return compressFormat;
    }

    public static byte[] getBitmapByteArray(Drawable drawable, View view) {
        byte[] imageByteArray = null;
        Bitmap bitmap = null;
        try {
            Drawable localDrawable = drawable;
            if (localDrawable != null && localDrawable instanceof StateListDrawable) {
                localDrawable = localDrawable.getCurrent();
            }
            if (localDrawable != null) {
                if (localDrawable instanceof BitmapDrawable) {
                    bitmap = ((BitmapDrawable)localDrawable).getBitmap();
                } else if (localDrawable instanceof NinePatchDrawable) {
                    NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)localDrawable;
                    if (view != null) {
                        if (view.getWidth() > 0 && view.getHeight() > 0) {
                            bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        }
                    } else {
                        bitmap = Bitmap.createBitmap((int)ninePatchDrawable.getIntrinsicWidth(), (int)ninePatchDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    if (bitmap != null) {
                        Canvas canvas = new Canvas(bitmap);
                        ninePatchDrawable.draw(canvas);
                    }
                }
                if (bitmap != null) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    bitmap.compress(ImageUtil.getCompressFormat(), ImageUtil.getPercentToCompressImage().intValue(), (OutputStream)stream);
                    imageByteArray = stream.toByteArray();
                }
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return imageByteArray;
    }

    public static long getColor(Drawable drawable) {
        block6: {
            if (drawable == null) {
                return 0L;
            }
            try {
                if (drawable instanceof StateListDrawable) {
                    if (drawable.getCurrent() instanceof NinePatchDrawable) {
                        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)drawable.getCurrent();
                        Bitmap bitmap = Bitmap.createBitmap((int)ninePatchDrawable.getIntrinsicWidth(), (int)ninePatchDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(bitmap);
                        ninePatchDrawable.draw(canvas);
                        return bitmap.getPixel(0, 0);
                    }
                    if (drawable.getCurrent() instanceof ColorDrawable) {
                        ColorDrawable colorDrawable = (ColorDrawable)drawable.getCurrent();
                        return ImageUtil.getColorHelper((Drawable)colorDrawable);
                    }
                    break block6;
                }
                return ImageUtil.getColorHelper(drawable);
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return 0L;
    }

    private static long getColorHelper(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.draw(canvas);
        long color = bitmap.getPixel(0, 0);
        return color;
    }

    public static String getMD5Hash(byte[] imageByteArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byteData = messageDigest.digest(imageByteArray);
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < byteData.length) {
                stringBuffer.append(Integer.toHexString(byteData[i] & 0xFF | 0x100).substring(1, 3));
                ++i;
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            LogInternal.logException(e);
            return null;
        }
    }
}

