/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.http.TLDefaultHttpClient;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.ImageUtil;
import com.tl.uic.util.JsonUtil;
import com.tl.uic.util.LogInternal;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class HTTPUtil {
    public static final String TLF_SESSION_ID_FROM_PCA = "TLTSID";
    private static volatile HTTPUtil _myInstance;
    private static final int SUCCESS_OK = 200;
    private static final int SUCCESS_IM_USED_RFC_3229 = 226;
    private static final int BUFFER_SIZE = 1024;

    private HTTPUtil() {
    }

    public static synchronized HTTPUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new HTTPUtil();
        }
        return _myInstance;
    }

    public static AbstractHttpEntity createEntity(String body, Boolean isGZip) throws IOException {
        StringEntity postBody = null;
        if (isGZip.booleanValue()) {
            byte[] originalBytes = body.getBytes("UTF-8");
            ByteArrayOutputStream bAOStream = new ByteArrayOutputStream(originalBytes.length);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bAOStream);
            gzipOutputStream.write(originalBytes);
            gzipOutputStream.finish();
            gzipOutputStream.close();
            postBody = new ByteArrayEntity(bAOStream.toByteArray());
        } else {
            postBody = new StringEntity(body);
        }
        return postBody;
    }

    public static Boolean sendHttpPost(String url, String sessionId, String json, Boolean isGZip, Boolean hasUICData) {
        if (json == null) {
            return false;
        }
        return HTTPUtil.sendPost(url, json, isGZip, true, hasUICData, null, null, sessionId, null);
    }

    public static Boolean sendHttpImagePost(String url, String sessionId, String directory, String fileName) {
        if (fileName == null) {
            return false;
        }
        return HTTPUtil.sendPost(url, null, false, false, false, directory, fileName, sessionId, null);
    }

    public static Boolean sendHttpImagePost(String url, String sessionId, String fileName, ByteArrayOutputStream image) {
        if (fileName == null) {
            return false;
        }
        return HTTPUtil.sendPost(url, null, false, false, false, null, fileName, sessionId, image);
    }

    private static Boolean sendPost(String url, String json, Boolean isGZip, Boolean isJson, Boolean hasUICData, String directory, String fileName, String sessionId, ByteArrayOutputStream image) {
        if (json == null && fileName == null && TLFCache.getEnvironmentalData() == null && TLFCache.getEnvironmentalData().getConnectionReceiver() == null && !TLFCache.getEnvironmentalData().getConnectionReceiver().isOnline().booleanValue()) {
            return false;
        }
        if (!TLFCache.getEnvironmentalData().getConnectionReceiver().isOnline().booleanValue()) {
            return false;
        }
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)ConfigurationUtil.getInt("PostMessageTimeout"));
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)ConfigurationUtil.getInt("PostMessageSocketTimeout"));
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
            TLDefaultHttpClient httpClient = new TLDefaultHttpClient((HttpParams)params, sessionId, hasUICData);
            String postUrl = isJson != false ? url : String.valueOf(url) + "?width=" + TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceWidth() + "&height=" + TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceHeight() + "&orientation=" + TLFCache.getEnvironmentalData().getScreenReceiver().getRotation();
            HttpPost httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Accept-Language", "en-US");
            if (JsonUtil.testMessageType(json, true).booleanValue()) {
                httpPost.addHeader(ConfigurationUtil.getString("MessageTypeHeader"), "true");
            }
            AbstractHttpEntity postBody = null;
            if (isJson.booleanValue()) {
                postBody = HTTPUtil.createEntity(json, isGZip);
                httpPost.setHeader("Content-Type", "text/json; charset=UTF-8");
                if (isGZip.booleanValue()) {
                    httpPost.setHeader("Content-Encoding", "gzip");
                }
            } else {
                httpPost.setHeader("X-Tealeaf-Mobile-Image", "Embedded");
                httpPost.setHeader("X-Tealeaf-Filename", fileName);
                if (image != null) {
                    postBody = new ByteArrayEntity(image.toByteArray());
                    postBody.setContentType("image/" + ImageUtil.getImageType());
                } else {
                    File dir = Tealeaf.getApplication().getApplicationContext().getDir(directory, 0);
                    File imageFile = new File(dir, fileName);
                    postBody = new FileEntity(imageFile, "image/" + ImageUtil.getImageType());
                }
            }
            httpPost.setEntity((HttpEntity)postBody);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HTTPUtil.updateCookies(httpClient, url);
            StatusLine status = httpResponse.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode >= 200 && statusCode <= 226) {
                return true;
            }
            LogInternal.log("Got back status code:" + statusCode + " from url:" + url);
        }
        catch (Exception e) {
            LogInternal.logException(e, "url:" + url);
        }
        return false;
    }

    private static Boolean updateCookies(DefaultHttpClient httpClient, String url) {
        CookieStore clientCookieStore = httpClient.getCookieStore();
        List cookies = clientCookieStore.getCookies();
        if (!cookies.isEmpty()) {
            CookieSyncManager syncManager = CookieSyncManager.getInstance();
            CookieManager appCookieManager = CookieManager.getInstance();
            if (appCookieManager != null) {
                for (Cookie cookie : cookies) {
                    StringBuilder addCookie = new StringBuilder();
                    addCookie.append(String.valueOf(cookie.getName()) + "=" + cookie.getValue());
                    addCookie.append("; domain=" + cookie.getDomain());
                    addCookie.append("; path=" + cookie.getPath());
                    if (cookie.getExpiryDate() != null) {
                        addCookie.append("; expiry=" + cookie.getExpiryDate());
                    }
                    if (cookie.isSecure()) {
                        addCookie.append(";Secure");
                    }
                    appCookieManager.setCookie(url, HTTPUtil.validateData(addCookie.toString()));
                    if (!cookie.getName().equalsIgnoreCase(ConfigurationUtil.getString("CookieParam")) || cookie.getValue().equals(Tealeaf.getCurrentSessionId())) continue;
                    Tealeaf.startSession(cookie.getValue());
                }
                syncManager.sync();
            }
        }
        return true;
    }

    public static String convertStreamToString(InputStream inputStream) throws IOException {
        String value = "";
        if (inputStream != null) {
            StringBuffer writer;
            block7: {
                writer = new StringBuffer();
                char[] buffer = new char[1024];
                try {
                    try {
                        int count;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        while ((count = reader.read(buffer)) != -1) {
                            writer.append(buffer, 0, count);
                        }
                    }
                    catch (Exception e) {
                        LogInternal.logException(e);
                        inputStream.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            value = writer.toString().trim();
        }
        return value;
    }

    public static String getCookieValue(URLConnection urlConnection, String cookieKey) {
        String cookieValue = null;
        if ((urlConnection == null || urlConnection.getHeaderFields() == null) && cookieKey == null) {
            return null;
        }
        CookieSyncManager syncManager = CookieSyncManager.getInstance();
        CookieManager appCookieManager = CookieManager.getInstance();
        LogInternal.log("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        LogInternal.log("Header from request:");
        for (Map.Entry<String, List<String>> entry : urlConnection.getHeaderFields().entrySet()) {
            if (entry == null) continue;
            LogInternal.log(String.valueOf(entry.getKey()) + ": " + entry.getValue() + "\n");
            if (entry.getKey() == null || !"Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
            for (String cookie : entry.getValue()) {
                String cookieName;
                if (appCookieManager != null) {
                    appCookieManager.setCookie(urlConnection.getURL().toString(), cookie);
                }
                if (!(cookieName = (cookie = cookie.substring(0, cookie.indexOf(59))).substring(0, cookie.indexOf(61))).equals(cookieKey)) continue;
                cookieValue = cookie.substring(cookie.indexOf(61) + 1, cookie.length());
            }
        }
        syncManager.sync();
        LogInternal.log("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        return cookieValue;
    }

    public static String getHeaders(Header[] header) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < header.length) {
            stringBuilder.append(String.valueOf(header[i].toString()) + "\n");
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String validateData(String data) {
        StringBuffer buffer = new StringBuffer();
        if (data != null) {
            buffer.append(data.trim().replaceAll("[\r\n]", ""));
        }
        return buffer.toString();
    }
}

