/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import com.tl.uic.Tealeaf;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GCUtil {
    private static volatile GCUtil _myInstance;

    private GCUtil() {
    }

    public static synchronized GCUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new GCUtil();
        }
        return _myInstance;
    }

    public static <T> Boolean clean(Object obj) {
        if (obj == null) {
            return false;
        }
        GCUtil.invokeCleanMethod(obj);
        return true;
    }

    public static <T> Boolean clean(List<T> list) {
        if (list == null || list.size() <= 0) {
            return false;
        }
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            GCUtil.invokeCleanMethod(element);
            element = null;
            try {
                iterator.remove();
            }
            catch (Exception ex) {
                Tealeaf.logException(ex);
            }
        }
        list.clear();
        return true;
    }

    public static <K, V> Boolean clean(ConcurrentHashMap<K, V> hashMap) {
        if (hashMap == null || hashMap.size() <= 0) {
            return false;
        }
        Set set = hashMap.keySet();
        for (Object element : set) {
            GCUtil.invokeCleanMethod(element);
            Object var3_3 = null;
        }
        hashMap.clear();
        return true;
    }

    public static <K, V> Boolean clean(HashMap<K, V> map) {
        if (map == null || map.size() <= 0) {
            return false;
        }
        Set<K> set = map.keySet();
        for (K element : set) {
            GCUtil.invokeCleanMethod(element);
            Object var3_3 = null;
        }
        map.clear();
        return true;
    }

    public static Boolean invokeCleanMethod(Object element) {
        if (element == null) {
            return false;
        }
        Class<?> clazz = element.getClass();
        try {
            Method method = clazz.getDeclaredMethod("clean", new Class[0]);
            method.invoke(element, new Object[0]);
        }
        catch (Exception ex) {
            Tealeaf.logException(ex);
        }
        return true;
    }
}

