/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import com.tl.uic.Tealeaf;
import com.tl.uic.model.TLFCacheFile;
import com.tl.uic.util.LogInternal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private static volatile FileUtil _myInstance;

    private FileUtil() {
    }

    public static synchronized FileUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new FileUtil();
        }
        return _myInstance;
    }

    public static Boolean saveObject(Object object, String directory, String filename) {
        File dir = null;
        File file = null;
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        Boolean hasBeenSaved = true;
        try {
            try {
                dir = Tealeaf.getApplication().getApplicationContext().getDir(directory, 0);
                file = new File(dir, filename);
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                LogInternal.log("Has been saved:" + hasBeenSaved + (hasBeenSaved != false ? " File to cache:" + file.getAbsolutePath() : ""));
            }
            catch (Exception e) {
                hasBeenSaved = false;
                LogInternal.logException(e, "Trying to save file to cache:" + (file == null ? "" : file.getAbsolutePath()));
                FileUtil.deleteFile(directory, filename);
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (!hasBeenSaved.booleanValue()) {
                        file.delete();
                    }
                }
                catch (Exception e2) {
                    LogInternal.logException(e2);
                }
            }
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (!hasBeenSaved.booleanValue()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return hasBeenSaved;
    }

    public static List<TLFCacheFile> getObjects(String directory) {
        ArrayList<TLFCacheFile> objects = new ArrayList<TLFCacheFile>();
        File dir = Tealeaf.getApplication().getApplicationContext().getDir(directory, 0);
        File[] fileList = dir.listFiles();
        Arrays.sort(fileList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return Long.valueOf(((File)obj1).lastModified()).compareTo(((File)obj2).lastModified());
            }
        });
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            int dotPosition = file.getName().lastIndexOf(".");
            String extension = file.getName().substring(dotPosition + 1, file.getName().length());
            if (!"png".equals(extension)) {
                Object object = FileUtil.getObject(file);
                if (object instanceof TLFCacheFile) {
                    objects.add((TLFCacheFile)object);
                }
                file.delete();
            }
            ++n2;
        }
        return objects;
    }

    public static Object getObject(File file) {
        if (file == null) {
            return null;
        }
        Object object = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    object = objectInputStream.readObject();
                }
            }
            catch (Exception e) {
                LogInternal.logException(e, "Trying to get object from file:" + file.getAbsolutePath());
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception e2) {
                    LogInternal.logException(e2);
                }
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return object;
    }

    public static Boolean deleteFile(String directory, String filename) {
        File dir = null;
        File file = null;
        Boolean hasBeenDeleted = false;
        try {
            dir = Tealeaf.getApplication().getApplicationContext().getDir(directory, 0);
            file = new File(dir, filename);
            if (file != null || file.exists()) {
                file.delete();
                hasBeenDeleted = true;
            }
            LogInternal.log("Has been deleted:" + hasBeenDeleted + (hasBeenDeleted != false ? " File from cache:" + file.getAbsolutePath() : ""));
        }
        catch (Exception e) {
            LogInternal.logException(e, "Trying to delete file from cache:" + (file == null ? "" : file.getAbsolutePath()));
        }
        return hasBeenDeleted;
    }
}

