/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.os.AsyncTask;
import com.tl.uic.Logger;
import com.tl.uic.TLFCache;
import com.tl.uic.model.Layout;
import com.tl.uic.util.LogInternal;
import java.lang.ref.WeakReference;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogLogScreenTask
extends AsyncTask<Void, Void, Layout> {
    private Dialog dialog;
    private WeakReference<Activity> activityWeakReference;
    private WeakReference<Logger> loggerWeakReference;
    private String name;
    private final int SLEEP_MS = 50;
    private final int MINUTE_MS = 60000;

    public DialogLogScreenTask(Logger logger, Activity activity, String name, Dialog dialog) {
        this.loggerWeakReference = new WeakReference<Logger>(logger);
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.name = name;
        this.dialog = dialog;
    }

    protected final Layout doInBackground(Void ... params) {
        Layout result = null;
        try {
            Logger logger;
            Calendar startTime = Calendar.getInstance();
            while (!this.dialog.isShowing()) {
                Thread.sleep(50L);
                Calendar currentTime = Calendar.getInstance();
                if (currentTime.getTimeInMillis() - startTime.getTimeInMillis() > 60000L) break;
            }
            if (this.dialog.isShowing() && this.loggerWeakReference != null && this.activityWeakReference != null && (logger = (Logger)this.loggerWeakReference.get()) != null) {
                result = logger.logLayout((Activity)this.activityWeakReference.get(), (AlertDialog)this.dialog, this.name, true);
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return result;
    }

    protected final void onPostExecute(Layout result) {
        TLFCache.addMessage(result);
    }
}

