/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.tl.uic.TLFCache;
import com.tl.uic.model.ReachabilityType;
import com.tl.uic.util.LogInternal;

public class ConnectionReceiver
extends BroadcastReceiver {
    private Boolean _isOnline = false;
    private ReachabilityType networkReachability = ReachabilityType.Unknown;
    private String connectionType;

    public final Boolean isOnline() {
        return this._isOnline;
    }

    public final ReachabilityType getNetworkReachability() {
        return this.networkReachability;
    }

    public final String getConnectionType() {
        return this.connectionType;
    }

    public final void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        this._isOnline = false;
        if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            TLFCache.setCurrentLogLevel(false, false, false);
            return;
        }
        boolean hasNoConnectivity = intent.getBooleanExtra("noConnectivity", false);
        NetworkInfo networkInfo = null;
        if (Build.VERSION.SDK_INT > 13) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null) {
                networkInfo = connectivityManager.getActiveNetworkInfo();
            }
        } else {
            networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
        }
        if (hasNoConnectivity || networkInfo == null) {
            this.setNoConnectivity();
        } else {
            if (networkInfo.getType() == 1) {
                this.networkReachability = ReachabilityType.ReachableViaWIFI;
                TLFCache.setCurrentLogLevel(true, true, false);
            } else if (networkInfo.getTypeName().contains("mobile")) {
                this.networkReachability = ReachabilityType.ReachableViaWWAN;
                TLFCache.setCurrentLogLevel(true, false, true);
            }
            this._isOnline = true;
        }
        if (networkInfo != null) {
            this.connectionType = networkInfo.getSubtypeName();
        }
        LogInternal.log("Network changed");
        if (TLFCache.getEnvironmentalData() != null) {
            TLFCache.getEnvironmentalData().hasClientStateChanged();
        }
    }

    private void setNoConnectivity() {
        this.networkReachability = ReachabilityType.NotReachable;
        this._isOnline = false;
        TLFCache.setCurrentLogLevel(false, false, false);
    }
}

