/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.app.Application;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.tl.uic.util.LogInternal;
import java.io.InputStream;
import java.util.Properties;

public final class ConfigurationUtil {
    private static Application application;
    private static Properties configurableItems;
    private static final String EMPTY_STRING = "";
    private static final String EXCEPTION_LOG_TITLE = "Key was ";
    private static volatile ConfigurationUtil _myInstance;
    private static final int MILLISECOND_CONVERTER = 1000;
    private static final int SECOND_CONVERTER = 60;
    private static final int MINIMUM_BOOLEAN_SIZE = 3;

    private ConfigurationUtil() {
    }

    public static synchronized ConfigurationUtil getInstance() {
        if (_myInstance == null) {
            _myInstance = new ConfigurationUtil();
        }
        return _myInstance;
    }

    public static void init(Application app) {
        application = app;
        configurableItems = ConfigurationUtil.getConfigurationSettings("TLFConfigurableItems.properties");
        if (configurableItems != null) {
            LogInternal.setIsDEBUG(ConfigurationUtil.getBoolean("DisplayLogging"));
            LogInternal.log(configurableItems.toString());
        }
        if (application != null) {
            CookieSyncManager.createInstance((Context)application.getApplicationContext());
            CookieManager.getInstance().setAcceptCookie(true);
        } else {
            LogInternal.log("Application passed to start library is null");
        }
    }

    public static String getString(String key) {
        String value = EMPTY_STRING;
        try {
            value = configurableItems.getProperty(key, EMPTY_STRING).trim();
        }
        catch (Exception e) {
            LogInternal.logException(e, EXCEPTION_LOG_TITLE + key);
        }
        return value;
    }

    public static int getIntMS(String key) {
        return ConfigurationUtil.getInt(key) * 1000;
    }

    public static int getInt(String key) {
        int intValue = -1;
        try {
            String value = ConfigurationUtil.getString(key);
            intValue = value.length() > 0 ? Integer.parseInt(value) : intValue;
        }
        catch (Exception e) {
            LogInternal.logException(e, EXCEPTION_LOG_TITLE + key);
        }
        return intValue;
    }

    public static long getLongMS(String key) {
        return ConfigurationUtil.getLong(key) * 1000L;
    }

    public static long getLongMSFromMinute(String key) {
        return ConfigurationUtil.getLong(key) * 1000L * 60L;
    }

    public static long getLong(String key) {
        long longValue = -1L;
        try {
            String value = ConfigurationUtil.getString(key);
            longValue = value.length() > 0 ? Long.parseLong(value) : longValue;
        }
        catch (Exception e) {
            LogInternal.logException(e, EXCEPTION_LOG_TITLE + key);
        }
        return longValue;
    }

    public static Boolean getBoolean(String key) {
        Boolean booleanValue = false;
        try {
            String value = ConfigurationUtil.getString(key);
            if (value.length() > 3) {
                booleanValue = Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            LogInternal.logException(e, EXCEPTION_LOG_TITLE + key);
        }
        return booleanValue;
    }

    private static Properties getConfigurationSettings(String propertiesFileName) {
        Properties properties = new Properties();
        if (application == null) {
            return properties;
        }
        try {
            Resources resources = application.getResources();
            AssetManager assetManager = resources.getAssets();
            InputStream inputStream = assetManager.open(propertiesFileName);
            properties.load(inputStream);
        }
        catch (Exception e) {
            LogInternal.logException(e, "Trying to load properties file: " + propertiesFileName);
        }
        return properties;
    }

    public static Boolean setProperty(String key, String value) {
        Boolean hasUpdated = false;
        if (configurableItems.containsKey(key)) {
            configurableItems.setProperty(key, value);
            hasUpdated = true;
        }
        return hasUpdated;
    }
}

