/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.util;

import android.os.AsyncTask;
import com.tl.uic.Tealeaf;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.HTTPUtil;
import com.tl.uic.util.LogInternal;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckWhiteListTask
extends AsyncTask<Void, Void, Map<String, String>> {
    public static final String TLF_SESSION_ID_KEY = "sessionId";
    public static final String TLF_KILL_SWITCH_ENABLED_KEY = "killSwitchEnabled";
    private Boolean startSession = false;

    public CheckWhiteListTask(Boolean startSession) {
        this.startSession = startSession;
    }

    protected final Map<String, String> doInBackground(Void ... args) {
        Map<String, String> result = null;
        try {
            result = CheckWhiteListTask.checkWhiteList();
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return result;
    }

    protected final void onPostExecute(Map<String, String> result) {
        Tealeaf.resultKillSwitch(result);
        if (this.startSession.booleanValue()) {
            Tealeaf.startSession(Tealeaf.getCurrentSessionId());
        }
    }

    public static Map<String, String> checkWhiteList() {
        Boolean hasBeenApproved = false;
        String url = ConfigurationUtil.getString("KillSwitchUrl");
        Boolean killSwitchEnabled = ConfigurationUtil.getBoolean("KillSwitchEnabled");
        Boolean useWhiteList = ConfigurationUtil.getBoolean("UseWhiteList");
        String whiteListParam = ConfigurationUtil.getString("WhiteListParam");
        Boolean useRandomSample = ConfigurationUtil.getBoolean("UseRandomSample");
        String randomSampleParam = ConfigurationUtil.getString("RandomSampleParam");
        int maxNumberOfTries = ConfigurationUtil.getInt("KillSwitchMaxNumberOfTries");
        long timeInternalOfTries = ConfigurationUtil.getLongMS("KillSwitchTimeInterval");
        StringBuffer killSwitchUrl = new StringBuffer(url);
        HashMap<String, String> values = new HashMap<String, String>();
        String cookieParam = ConfigurationUtil.getString("CookieParam");
        if (killSwitchEnabled.booleanValue()) {
            String body = null;
            if (url.contains("?")) {
                killSwitchUrl.append('&');
            } else {
                killSwitchUrl.append('?');
            }
            if (useWhiteList.booleanValue()) {
                killSwitchUrl.append(whiteListParam);
            } else if (useRandomSample.booleanValue()) {
                killSwitchUrl.append(randomSampleParam);
            }
            killSwitchUrl.append('=');
            killSwitchUrl.append(Tealeaf.getPhoneId());
            try {
                URL urlObject = new URL(killSwitchUrl.toString());
                URLConnection urlConnection = urlObject.openConnection();
                InputStream inputStream = urlConnection.getInputStream();
                body = HTTPUtil.convertStreamToString(inputStream);
                String cookieValue = HTTPUtil.getCookieValue(urlConnection, cookieParam);
                values.put(TLF_SESSION_ID_KEY, cookieValue);
            }
            catch (IOException urlObject) {
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
            Integer index = 0;
            while (index < maxNumberOfTries) {
                if (body != null) {
                    if ("1".equals(body)) {
                        hasBeenApproved = true;
                    }
                    index = maxNumberOfTries;
                }
                if (index < maxNumberOfTries) {
                    try {
                        Thread.sleep(timeInternalOfTries);
                    }
                    catch (Exception e) {
                        LogInternal.logException(e);
                    }
                }
                index = index + 1;
            }
        }
        values.put(TLF_KILL_SWITCH_ENABLED_KEY, hasBeenApproved.toString());
        return values;
    }
}

