/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.JsonBase;
import com.tl.uic.model.TableRowStyleType;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import org.json.JSONObject;

public class Style
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -8622804542409266251L;
    private static final long STRIP_BITS = 0xFFFFFFL;
    private long textColor;
    private long textAlphaColor;
    private long textBGColor;
    private long textBGAlphaColor;
    private long bgColor;
    private long bgAlphaColor;
    private Boolean hidden;
    private String textAlignment;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private int paddingLeft;
    private TableRowStyleType tableRowStyle;
    private long tableRowStyleColor;

    public Style() {
        this.clean();
    }

    public final long getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(long textColor) {
        this.textColor = this.convertToUnsignedInt(textColor);
    }

    public final long getTextAlphaColor() {
        return this.textAlphaColor;
    }

    public final void setTextAlphaColor(long textAlphaColor) {
        this.textAlphaColor = this.convertToUnsignedInt(textAlphaColor);
    }

    public final long getTextBGColor() {
        return this.textBGColor;
    }

    public final void setTextBGColor(long textBGColor) {
        this.textBGColor = this.convertToUnsignedInt(textBGColor);
    }

    public final long getTextBGAlphaColor() {
        return this.textBGAlphaColor;
    }

    public final void setTextBGAlphaColor(long textBGAlphaColor) {
        this.textBGAlphaColor = this.convertToUnsignedInt(textBGAlphaColor);
    }

    public final long getBgColor() {
        return this.bgColor;
    }

    public final void setBgColor(long bgColor) {
        this.bgColor = this.convertToUnsignedInt(bgColor);
    }

    public final long getBgAlphaColor() {
        return this.bgAlphaColor;
    }

    public final void setBgAlphaColor(int bgAlphaColor) {
        this.bgAlphaColor = this.convertToUnsignedInt(bgAlphaColor);
    }

    public final Boolean getHidden() {
        return this.hidden;
    }

    public final void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public final String getTextAlignment() {
        return this.textAlignment;
    }

    public final void setTextAlignment(String textAlignment) {
        this.textAlignment = textAlignment;
    }

    public final int getPaddingTop() {
        return this.paddingTop;
    }

    public final void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public final int getPaddingRight() {
        return this.paddingRight;
    }

    public final void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public final int getPaddingBottom() {
        return this.paddingBottom;
    }

    public final void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public final int getPaddingLeft() {
        return this.paddingLeft;
    }

    public final void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public final TableRowStyleType getTableRowStyle() {
        return this.tableRowStyle;
    }

    public final void setTableRowStyle(TableRowStyleType tableRowStyle) {
        this.tableRowStyle = tableRowStyle;
    }

    public final long getTableRowStyleColor() {
        return this.tableRowStyleColor;
    }

    public final void setTableRowStyleColor(long tableRowStyleColor) {
        this.tableRowStyleColor = tableRowStyleColor;
    }

    public final JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.getTextColor() != -1L) {
                jsonObject.put("textColor", this.getTextColor());
            }
            if (this.getTextAlphaColor() != -1L) {
                jsonObject.put("textAlphaColor", this.getTextAlphaColor());
            }
            if (this.getBgColor() != -1L) {
                jsonObject.put("textBGColor", this.getBgColor());
            }
            if (this.getTextBGAlphaColor() != -1L) {
                jsonObject.put("textBGAlphaColor", this.getTextBGAlphaColor());
            }
            if (this.getBgColor() != -1L) {
                jsonObject.put("bgColor", this.getBgColor());
            }
            if (this.getBgAlphaColor() != -1L) {
                jsonObject.put("bgAlphaColor", this.getBgAlphaColor());
            }
            if (this.getTextAlignment() != null) {
                jsonObject.put("textAlign", (Object)this.getTextAlignment());
            }
            if (this.getPaddingBottom() != -1) {
                jsonObject.put("paddingBottom", this.getPaddingBottom());
            }
            if (this.getPaddingLeft() != -1) {
                jsonObject.put("paddingLeft", this.getPaddingLeft());
            }
            if (this.getPaddingRight() != -1) {
                jsonObject.put("paddingRight", this.getPaddingRight());
            }
            if (this.getPaddingTop() != -1) {
                jsonObject.put("paddingTop", this.getPaddingTop());
            }
            if (this.getTableRowStyle() != null) {
                jsonObject.put("tableRowStyle", (Object)this.getTableRowStyle().toString());
            }
            if (this.getTableRowStyleColor() != -1L) {
                jsonObject.put("tableRowStyleColor", this.getTableRowStyleColor());
            }
            jsonObject.put("hidden", (Object)this.getHidden());
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    public final Boolean clean() {
        this.textColor = -1L;
        this.textAlphaColor = -1L;
        this.textBGColor = -1L;
        this.textBGAlphaColor = -1L;
        this.bgColor = -1L;
        this.bgAlphaColor = -1L;
        this.hidden = false;
        this.textAlignment = null;
        this.paddingBottom = -1;
        this.paddingLeft = -1;
        this.paddingRight = -1;
        this.paddingTop = -1;
        this.tableRowStyle = null;
        this.tableRowStyleColor = -1L;
        return true;
    }

    public final Long convertToUnsignedInt(long intValue) {
        return intValue & 0xFFFFFFL;
    }
}

