/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientEnvironment;
import com.tl.uic.model.JSONMessage;
import com.tl.uic.model.JsonBase;
import com.tl.uic.util.GCUtil;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -5461457368043986640L;
    private String sessionID;
    private long sessionStartTime;
    private List<JSONMessage> messages = new CopyOnWriteArrayList<JSONMessage>();
    private ClientEnvironment clientEnvironment;
    private Boolean hasUICData = false;

    public final String getSessionID() {
        return this.sessionID;
    }

    public final void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public final long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public final void setSessionStartTime(long sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }

    public final List<JSONMessage> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<JSONMessage>();
        }
        return this.messages;
    }

    public final Boolean cleanMessages() {
        return GCUtil.clean(this.messages);
    }

    public final void setMessages(List<JSONMessage> messages) {
        this.messages = messages;
    }

    public final ClientEnvironment getClientEnvironment() {
        return this.clientEnvironment;
    }

    public final void setClientEnvironment(ClientEnvironment clientEnvironment) {
        this.clientEnvironment = clientEnvironment;
    }

    public final Boolean getHasUICData() {
        return this.hasUICData;
    }

    public final void setHasUICData(Boolean hasUICData) {
        this.hasUICData = hasUICData;
    }

    @Override
    public final JSONObject getJSON() {
        JSONObject mainJsonObject = new JSONObject();
        try {
            mainJsonObject.put("id", (Object)this.getSessionID());
            mainJsonObject.put("startTime", this.getSessionStartTime());
            JSONArray jsonSessions = new JSONArray();
            for (JSONMessage jsonClass : this.getMessages()) {
                JSONObject jsonObject = new JSONObject(jsonClass.getJsonData());
                jsonSessions.put((Object)jsonObject);
            }
            mainJsonObject.put("messages", (Object)jsonSessions);
            mainJsonObject.put("clientEnvironment", (Object)this.getClientEnvironment().getJSON());
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return mainJsonObject;
    }

    @Override
    public final Boolean clean() {
        return true;
    }
}

