/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.model.ScreenviewType;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import org.json.JSONObject;

public class Screenview
extends ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -7422132544374507473L;
    private String logicalPageName;
    private ScreenviewType screenviewType;
    private String referringLogicalPageName;

    public Screenview() {
        this.init();
    }

    public Screenview(String logicalPageName, ScreenviewType screenviewType, String referrer) {
        this.init();
        this.logicalPageName = logicalPageName;
        this.screenviewType = screenviewType;
        this.referringLogicalPageName = referrer;
    }

    private void init() {
        this.setMessageType(MessageType.SCREENVIEW);
        this.setLogLevel(0);
    }

    public final String getLogicalPageName() {
        return this.logicalPageName;
    }

    public final void setLogicalPageName(String logicalPageName) {
        this.logicalPageName = logicalPageName;
    }

    public final String getReferringLogicalPageName() {
        return this.referringLogicalPageName;
    }

    public final void setReferringLogicalPageName(String referringLogicalPageName) {
        this.referringLogicalPageName = referringLogicalPageName;
    }

    public final ScreenviewType getScreenviewType() {
        return this.screenviewType;
    }

    public final void setScreenviewType(ScreenviewType screenviewType) {
        this.screenviewType = screenviewType;
    }

    public final JSONObject getJSON() {
        JSONObject jsonObject = null;
        JSONObject jsonInnerObject = new JSONObject();
        try {
            jsonObject = super.getJSON();
            jsonInnerObject.put("type", (Object)this.getScreenviewType());
            jsonInnerObject.put("name", (Object)this.getLogicalPageName());
            if (this.getScreenviewType().equals(ScreenviewType.LOAD) && this.getReferringLogicalPageName() != null) {
                jsonInnerObject.put("referrer", (Object)this.getReferringLogicalPageName());
            }
            jsonObject.put("screenview", (Object)jsonInnerObject);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    public final Boolean clean() {
        super.clean();
        this.logicalPageName = null;
        this.screenviewType = null;
        this.referringLogicalPageName = null;
        return true;
    }
}

