/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.AndroidState;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.ReachabilityType;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import org.json.JSONObject;

public class MobileState
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -2088868938362419070L;
    private long freeStorage;
    private long freeMemory;
    private double battery;
    private String ip;
    private String carrier;
    private int orientation;
    private String connectionType;
    private ReachabilityType networkReachability;
    private AndroidState androidState;

    public final long getFreeStorage() {
        return this.freeStorage;
    }

    public final void setFreeStorage(long freeStorage) {
        this.freeStorage = freeStorage;
    }

    public final long getFreeMemory() {
        return this.freeMemory;
    }

    public final void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public final double getBattery() {
        return this.battery;
    }

    public final void setBattery(double battery) {
        this.battery = battery;
    }

    public final String getIp() {
        return this.ip;
    }

    public final void setIp(String ip) {
        this.ip = ip;
    }

    public final String getCarrier() {
        return this.carrier;
    }

    public final void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public final String getConnectionType() {
        return this.connectionType;
    }

    public final void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public final ReachabilityType getNetworkReachability() {
        return this.networkReachability;
    }

    public final void setNetworkReachability(ReachabilityType networkReachability) {
        this.networkReachability = networkReachability;
    }

    public final AndroidState getAndroidState() {
        return this.androidState;
    }

    public final void setAndroidState(AndroidState androidState) {
        this.androidState = androidState;
    }

    public final JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("freeStorage", this.getFreeStorage());
            jsonObject.put("freeMemory", this.getFreeMemory());
            jsonObject.put("battery", this.getBattery() == -1.0 ? "N/A" : Double.valueOf(this.getBattery()));
            jsonObject.put("ip", (Object)this.getIp());
            jsonObject.put("carrier", (Object)this.getCarrier());
            jsonObject.put("orientation", this.getOrientation());
            jsonObject.put("connectionType", (Object)this.getConnectionType());
            jsonObject.put("networkReachability", (Object)(this.getNetworkReachability() == null ? "N/A" : this.getNetworkReachability().name()));
            jsonObject.put("androidState", (Object)this.getAndroidState().getJSON());
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + (this.androidState == null ? 0 : this.androidState.hashCode());
        long temp = Double.doubleToLongBits(this.battery);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.carrier == null ? 0 : this.carrier.hashCode());
        result = 31 * result + (this.connectionType == null ? 0 : this.connectionType.hashCode());
        result = 31 * result + (int)(this.freeMemory ^ this.freeMemory >>> 32);
        result = 31 * result + (int)(this.freeStorage ^ this.freeStorage >>> 32);
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.networkReachability == null ? 0 : this.networkReachability.hashCode());
        result = 31 * result + this.orientation;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        MobileState other = (MobileState)obj;
        if (this.androidState == null ? other.androidState != null : !this.androidState.equals(other.androidState)) {
            return false;
        }
        if (Math.abs(this.battery - other.battery) > (double)ConfigurationUtil.getLong("BatterySensitivity")) {
            return false;
        }
        if (this.carrier == null ? other.carrier != null : !this.carrier.equals(other.carrier)) {
            return false;
        }
        if (this.connectionType == null ? other.connectionType != null : !this.connectionType.equals(other.connectionType)) {
            return false;
        }
        if (Math.abs(this.freeMemory - other.freeMemory) > ConfigurationUtil.getLong("FreeMemorySensitivity")) {
            return false;
        }
        if (Math.abs(this.freeStorage - other.freeStorage) > ConfigurationUtil.getLong("FreeStorageSensitivity")) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.networkReachability != other.networkReachability) {
            return false;
        }
        return this.orientation == other.orientation;
    }

    public final Boolean clean() {
        this.freeStorage = 0L;
        this.freeMemory = 0L;
        this.battery = 0.0;
        this.ip = null;
        this.carrier = null;
        this.orientation = 0;
        this.connectionType = null;
        this.networkReachability = null;
        if (this.androidState != null) {
            this.androidState.clean();
            this.androidState = null;
        }
        return true;
    }
}

