/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.BaseTarget;
import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.model.Style;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -2283935892858105240L;
    private String name;
    private List<BaseTarget> controls;
    private Style style;
    private String className;

    public Layout() {
        this.setMessageType(MessageType.LAYOUT);
        this.setControls(new CopyOnWriteArrayList<BaseTarget>());
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final List<BaseTarget> getControls() {
        return this.controls;
    }

    public final void setControls(List<BaseTarget> controls) {
        this.controls = controls;
    }

    public final Style getStyle() {
        return this.style;
    }

    public final void setStyle(Style style) {
        this.style = style;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(String className) {
        this.className = className;
    }

    @Override
    public final JSONObject getJSON() {
        JSONObject jsonObject = null;
        JSONObject jsonInnerObject = new JSONObject();
        try {
            jsonObject = super.getJSON();
            jsonInnerObject.put("name", (Object)this.getName());
            jsonInnerObject.put("class", (Object)this.getClassName());
            jsonInnerObject.put("style", this.getStyle() == null ? null : this.getStyle().getJSON());
            JSONArray jsonControls = new JSONArray();
            for (BaseTarget jsonClass : this.getControls()) {
                jsonControls.put((Object)jsonClass.getJSON());
            }
            jsonInnerObject.put("controls", (Object)jsonControls);
            jsonObject.put("layout", (Object)jsonInnerObject);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    @Override
    public final Boolean clean() {
        super.clean();
        return true;
    }
}

