/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientMessageHeader;
import java.io.Serializable;

public class JSONMessage
implements Serializable {
    private static final long serialVersionUID = 3976757161355685264L;
    private String jsonData;
    private int logLevel;
    private long size;
    private Boolean hasUICData;
    private static final int prime = 31;

    public JSONMessage(Boolean hasUICData) {
        this.logLevel = 0;
        this.jsonData = "";
        this.size = 0L;
        this.hasUICData = hasUICData;
    }

    public JSONMessage(ClientMessageHeader message) {
        this.logLevel = message.getLogLevel();
        this.jsonData = message.getJSON().toString();
        this.size = 0L;
        this.hasUICData = false;
    }

    public final String getJsonData() {
        return this.jsonData;
    }

    public final void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long size) {
        this.size = size;
    }

    public final Boolean getHasUICData() {
        return this.hasUICData;
    }

    public final void setHasUICData(Boolean hasUICData) {
        this.hasUICData = hasUICData;
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + (this.jsonData == null ? 0 : this.jsonData.hashCode());
        result = 31 * result + this.logLevel;
        result = 31 * result + this.hasUICData.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONMessage other = (JSONMessage)obj;
        if (this.jsonData == null ? other.jsonData != null : !this.jsonData.equals(other.jsonData)) {
            return false;
        }
        if (this.logLevel != other.logLevel) {
            return false;
        }
        return this.hasUICData == other.hasUICData;
    }

    public final String toString() {
        StringBuffer toStringValue = new StringBuffer("JSONMessage [jsonData=");
        toStringValue.append(this.jsonData);
        toStringValue.append(", logLevel=");
        toStringValue.append(this.logLevel);
        toStringValue.append(", size=");
        toStringValue.append(this.size);
        toStringValue.append(", hasUICData=");
        toStringValue.append(this.hasUICData);
        toStringValue.append(']');
        return toStringValue.toString();
    }

    public final Boolean clean() {
        this.jsonData = null;
        this.logLevel = 0;
        this.size = 0L;
        this.hasUICData = false;
        return true;
    }
}

