/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.util.JsonUtil;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONException
extends ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = 1817811642841780549L;
    private String name;
    private String description;
    private String stackTrace;
    private HashMap<String, String> data;

    public JSONException() {
        this.setMessageType(MessageType.EXCEPTION);
        this.setLogLevel(0);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getStackTrace() {
        return this.stackTrace;
    }

    public final void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public final HashMap<String, String> getData() {
        return this.data;
    }

    public final void setData(HashMap<String, String> data) {
        this.data = data;
    }

    @Override
    public final JSONObject getJSON() {
        JSONObject jsonObject = null;
        JSONObject jsonInnerObject = new JSONObject();
        try {
            jsonObject = super.getJSON();
            jsonInnerObject.put("name", (Object)this.getName());
            jsonInnerObject.put("description", (Object)this.getDescription());
            jsonInnerObject.put("stackTrace", (Object)this.getStackTrace());
            if (this.getData() != null) {
                jsonInnerObject.put("data", (Object)JsonUtil.getStringHashValues(this.getData()));
            }
            jsonObject.put("exception", (Object)jsonInnerObject);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    @Override
    public final Boolean clean() {
        super.clean();
        this.name = null;
        this.description = null;
        this.stackTrace = null;
        return true;
    }
}

