/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.util.GCUtil;
import com.tl.uic.util.JsonUtil;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEvent
extends ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -4501300217682609050L;
    private String name;
    private HashMap<String, String> data;

    public CustomEvent() {
        this.setMessageType(MessageType.CUSTOM_EVENT);
    }

    public CustomEvent(int logLevel, String name, HashMap<String, String> data) {
        this.setMessageType(MessageType.CUSTOM_EVENT);
        this.setLogLevel(logLevel);
        this.data = data;
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final HashMap<String, String> getData() {
        return this.data;
    }

    public final void setData(HashMap<String, String> data) {
        this.data = data;
    }

    @Override
    public final JSONObject getJSON() {
        JSONObject jsonObject = null;
        JSONObject jsonInnerObject = new JSONObject();
        try {
            jsonObject = super.getJSON();
            jsonInnerObject.put("name", (Object)this.getName());
            jsonInnerObject.put("data", (Object)JsonUtil.getStringHashValues(this.getData()));
            jsonObject.put("customEvent", (Object)jsonInnerObject);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    @Override
    public final Boolean clean() {
        super.clean();
        this.name = null;
        GCUtil.clean(this.data);
        this.data = null;
        return true;
    }
}

