/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.EventInfo;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.model.Target;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import org.json.JSONObject;

public class Control
extends ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = -859543818892459798L;
    private Target target;
    private EventInfo eventInfo;
    private long focusInOffset;

    public Control() {
        this.setMessageType(MessageType.CONTROL);
    }

    public final Target getTarget() {
        return this.target;
    }

    public final void setTarget(Target target) {
        this.target = target;
    }

    public final EventInfo getEventInfo() {
        return this.eventInfo;
    }

    public final void setEventInfo(EventInfo eventInfo) {
        this.eventInfo = eventInfo;
    }

    public final long getFocusInOffset() {
        return this.focusInOffset;
    }

    public final void setFocusInOffset(long focusInOffset) {
        this.focusInOffset = focusInOffset;
    }

    public final JSONObject getJSON() {
        JSONObject jsonObject = null;
        try {
            jsonObject = super.getJSON();
            if (this.getFocusInOffset() > 0L) {
                jsonObject.put("focusInOffset", this.getFocusInOffset());
            }
            if (this.getTarget() != null) {
                jsonObject.put("target", (Object)this.getTarget().getJSON());
            }
            if (this.getEventInfo() != null) {
                jsonObject.put("event", (Object)this.getEventInfo().getJSON());
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    public final int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.eventInfo == null ? 0 : this.eventInfo.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Control other = (Control)obj;
        if (this.eventInfo == null ? other.eventInfo != null : !this.eventInfo.equals(other.eventInfo)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public final Boolean clean() {
        super.clean();
        this.target.clean();
        this.target = null;
        this.eventInfo.clean();
        this.eventInfo = null;
        this.focusInOffset = 0L;
        return true;
    }
}

